/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c8.wiring;

import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.CommandWrapper;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.vanillabp.spi.service.MultiInstanceElementResolver;
import io.vanillabp.spi.service.TaskEvent;
import io.vanillabp.spi.service.TaskException;
import io.vanillabp.springboot.adapter.MultiInstance;
import io.vanillabp.springboot.adapter.TaskHandlerBase;
import io.vanillabp.springboot.parameters.MethodParameter;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.community.vanillabp.c8.deployment.DeploymentService;
import org.camunda.community.vanillabp.c8.wiring.Camunda8Connectable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Transactional;

public class Camunda8TaskHandler
extends TaskHandlerBase
implements JobHandler {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8TaskHandler.class);
    private final DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final Camunda8Connectable.Type taskType;
    private final DeploymentService deploymentService;
    private final String idPropertyName;

    public Camunda8TaskHandler(Camunda8Connectable.Type taskType, DeploymentService deploymentService, DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy, CrudRepository<Object, String> workflowDomainEntityRepository, Object bean, Method method, List<MethodParameter> parameters, String idPropertyName) {
        super(workflowDomainEntityRepository, bean, method, parameters);
        this.deploymentService = deploymentService;
        this.taskType = taskType;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.idPropertyName = idPropertyName;
    }

    protected Logger getLogger() {
        return logger;
    }

    @Transactional
    public void handle(JobClient client, ActivatedJob job) throws Exception {
        CommandWrapper command = null;
        try {
            String businessKey = (String)this.getVariable(job, this.idPropertyName);
            logger.trace("Will handle task '{}' of workflow '{}' ('{}') as job '{}'", new Object[]{job.getElementId(), job.getProcessInstanceKey(), job.getProcessDefinitionKey(), job.getKey()});
            AtomicBoolean taskIdRetrieved = new AtomicBoolean(false);
            Object domainEntity = super.execute(businessKey, multiInstanceVariable -> this.getVariable(job, (String)multiInstanceVariable), taskParameter -> this.getVariable(job, (String)taskParameter), () -> {
                taskIdRetrieved.set(true);
                return Long.toHexString(job.getKey());
            }, () -> TaskEvent.Event.CREATED);
            if (this.taskType != Camunda8Connectable.Type.USERTASK && !taskIdRetrieved.get()) {
                command = this.createCompleteCommand(client, job, domainEntity);
            }
        }
        catch (TaskException bpmnError) {
            command = this.createThrowErrorCommand(client, job, bpmnError);
        }
        catch (Exception e) {
            logger.error("Failed to execute job '{}'", (Object)job.getKey(), (Object)e);
            command = this.createFailedCommand(client, job, e);
        }
        if (command != null) {
            command.executeAsync();
        }
    }

    protected Object getMultiInstanceElement(String name, Function<String, Object> multiInstanceSupplier) {
        return multiInstanceSupplier.apply(name);
    }

    protected Integer getMultiInstanceIndex(String name, Function<String, Object> multiInstanceSupplier) {
        return (Integer)multiInstanceSupplier.apply(name + "_index") - 1;
    }

    protected Integer getMultiInstanceTotal(String name, Function<String, Object> multiInstanceSupplier) {
        return (Integer)multiInstanceSupplier.apply(name + "_total");
    }

    protected MultiInstance<Object> getMultiInstance(String name, Function<String, Object> multiInstanceSupplier) {
        return new MultiInstance(this.getMultiInstanceElement(name, multiInstanceSupplier), this.getMultiInstanceTotal(name, multiInstanceSupplier).intValue(), this.getMultiInstanceIndex(name, multiInstanceSupplier).intValue());
    }

    private Object getVariable(ActivatedJob job, String name) {
        return job.getVariablesAsMap().get(name);
    }

    @Deprecated
    protected Map<String, MultiInstanceElementResolver.MultiInstance<Object>> getMultiInstanceContext(ActivatedJob job, String workflowDomainEntityId) {
        LinkedHashMap<String, MultiInstanceElementResolver.MultiInstance<Object>> result = new LinkedHashMap<String, MultiInstanceElementResolver.MultiInstance<Object>>();
        Process process = this.deploymentService.getProcess(job.getProcessDefinitionKey());
        ModelInstance model = process.getModelInstance();
        String miElement = job.getElementId();
        MultiInstanceLoopCharacteristics loopCharacteristics = null;
        while (loopCharacteristics == null) {
            ModelElementInstance bpmnElement = model.getModelElementById(miElement);
            if (bpmnElement instanceof Activity) {
                loopCharacteristics = (MultiInstanceLoopCharacteristics)((Activity)bpmnElement).getLoopCharacteristics();
            }
            if (loopCharacteristics == null) {
                miElement = bpmnElement.getParentElement() != null ? ((BaseElement)bpmnElement.getParentElement()).getId() : null;
            } else {
                result.put(((BaseElement)bpmnElement).getId(), (MultiInstanceElementResolver.MultiInstance<Object>)new MultiInstance(null, -1, -1));
            }
            if (miElement != null || loopCharacteristics != null) continue;
            throw new RuntimeException("No multi-instance context found for element '" + job.getElementId() + "' or its parents! In case of a call-activity this is not supported by ");
        }
        return result;
    }

    public CommandWrapper createCompleteCommand(JobClient jobClient, ActivatedJob job, Object domainEntity) {
        CompleteJobCommandStep1 completeCommand = jobClient.newCompleteCommand(job.getKey());
        if (domainEntity != null) {
            completeCommand = completeCommand.variables(domainEntity);
        }
        return new CommandWrapper((FinalCommandStep)completeCommand, job, (CommandExceptionHandlingStrategy)this.commandExceptionHandlingStrategy);
    }

    private CommandWrapper createThrowErrorCommand(JobClient jobClient, ActivatedJob job, TaskException bpmnError) {
        return new CommandWrapper((FinalCommandStep)jobClient.newThrowErrorCommand(job.getKey()).errorCode(bpmnError.getErrorCode()).errorMessage(bpmnError.getErrorName()), job, (CommandExceptionHandlingStrategy)this.commandExceptionHandlingStrategy);
    }

    private CommandWrapper createFailedCommand(JobClient jobClient, ActivatedJob job, Exception e) {
        return new CommandWrapper((FinalCommandStep)jobClient.newFailCommand(job).retries(0).errorMessage(e.getMessage()), job, (CommandExceptionHandlingStrategy)this.commandExceptionHandlingStrategy);
    }
}

