/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c8.wiring;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.model.bpmn.impl.BpmnModelInstanceImpl;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.UserTask;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeFormDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeLoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.vanillabp.springboot.adapter.SpringDataUtil;
import io.vanillabp.springboot.adapter.TaskWiringBase;
import io.vanillabp.springboot.parameters.MethodParameter;
import io.vanillabp.springboot.parameters.MethodParameterFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.persistence.Id;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.community.vanillabp.c8.service.Camunda8ProcessService;
import org.camunda.community.vanillabp.c8.wiring.Camunda8Connectable;
import org.camunda.community.vanillabp.c8.wiring.Camunda8TaskHandler;
import org.camunda.community.vanillabp.c8.wiring.Camunda8UserTaskHandler;
import org.camunda.community.vanillabp.c8.wiring.parameters.Camunda8MethodParameterFactory;
import org.camunda.community.vanillabp.c8.wiring.parameters.ParameterVariables;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.CrudRepository;

public class Camunda8TaskWiring
extends TaskWiringBase<Camunda8Connectable, Camunda8ProcessService<?>>
implements Consumer<ZeebeClient> {
    private final String workerId;
    private final SpringDataUtil springDataUtil;
    private final ObjectProvider<Camunda8TaskHandler> taskHandlers;
    private final Collection<Camunda8ProcessService<?>> connectableServices;
    private final Camunda8UserTaskHandler userTaskHandler;
    private ZeebeClient client;
    private List<JobWorkerBuilderStep1.JobWorkerBuilderStep3> workers = new LinkedList<JobWorkerBuilderStep1.JobWorkerBuilderStep3>();

    public Camunda8TaskWiring(SpringDataUtil springDataUtil, ApplicationContext applicationContext, String workerId, Camunda8UserTaskHandler userTaskHandler, ObjectProvider<Camunda8TaskHandler> taskHandlers, Collection<Camunda8ProcessService<?>> connectableServices) {
        super(applicationContext, (MethodParameterFactory)new Camunda8MethodParameterFactory());
        this.workerId = workerId;
        this.springDataUtil = springDataUtil;
        this.taskHandlers = taskHandlers;
        this.userTaskHandler = userTaskHandler;
        this.connectableServices = connectableServices;
    }

    @Override
    public void accept(ZeebeClient client) {
        this.client = client;
        this.workers.add(client.newWorker().jobType("io.camunda.zeebe:userTask").handler((JobHandler)this.userTaskHandler).name(this.workerId));
    }

    public void openWorkers() {
        this.workers.stream().forEach(JobWorkerBuilderStep1.JobWorkerBuilderStep3::open);
    }

    public Stream<Camunda8Connectable> connectablesForType(Process process, BpmnModelInstanceImpl model, Class<? extends BaseElement> type) {
        Camunda8Connectable.Type kind = UserTask.class.isAssignableFrom(type) ? Camunda8Connectable.Type.USERTASK : Camunda8Connectable.Type.TASK;
        Stream<Camunda8Connectable> stream = model.getModelElementsByType(type).stream().filter(element -> Camunda8TaskWiring.getOwningProcess((ModelElementInstance)element).equals(process)).map(element -> new Camunda8Connectable(process, element.getId(), kind, this.getTaskDefinition(kind, (BaseElement)element), (ZeebeLoopCharacteristics)element.getSingleExtensionElement(ZeebeLoopCharacteristics.class))).filter(connectable -> connectable.isExecutableProcess());
        if (kind == Camunda8Connectable.Type.USERTASK) {
            return stream;
        }
        return stream.filter(connectable -> connectable.getTaskDefinition() != null);
    }

    private String getTaskDefinition(Camunda8Connectable.Type kind, BaseElement element) {
        if (kind == Camunda8Connectable.Type.USERTASK) {
            ZeebeFormDefinition formDefinition = (ZeebeFormDefinition)element.getSingleExtensionElement(ZeebeFormDefinition.class);
            if (formDefinition == null) {
                return null;
            }
            return formDefinition.getFormKey();
        }
        ZeebeTaskDefinition taskDefinition = (ZeebeTaskDefinition)element.getSingleExtensionElement(ZeebeTaskDefinition.class);
        if (taskDefinition == null) {
            return null;
        }
        return taskDefinition.getType();
    }

    static Process getOwningProcess(ModelElementInstance element) {
        if (element instanceof Process) {
            return (Process)element;
        }
        ModelElementInstance parent = element.getParentElement();
        if (parent == null) {
            return null;
        }
        return Camunda8TaskWiring.getOwningProcess(parent);
    }

    protected <DE> Camunda8ProcessService<?> connectToBpms(String workflowModuleId, Class<DE> workflowAggregateClass, String bpmnProcessId) {
        Camunda8ProcessService processService = this.connectableServices.stream().filter(service -> service.getWorkflowAggregateClass().equals(workflowAggregateClass)).findFirst().get();
        processService.wire(this.client, workflowModuleId, bpmnProcessId);
        return processService;
    }

    protected void connectToBpms(Camunda8ProcessService<?> processService, Object bean, Camunda8Connectable connectable, Method method, List<MethodParameter> parameters) {
        CrudRepository<?, String> repository = processService.getWorkflowAggregateRepository();
        String idPropertyName = this.getWorkflowDomainEntityIdPropertyName(processService.getWorkflowAggregateClass());
        Camunda8TaskHandler taskHandler = (Camunda8TaskHandler)((Object)this.taskHandlers.getObject(new Object[]{this.springDataUtil, repository, connectable.getType(), connectable.getTaskDefinition(), bean, method, parameters, idPropertyName}));
        if (connectable.getType() == Camunda8Connectable.Type.USERTASK) {
            this.userTaskHandler.addTaskHandler(connectable.getBpmnProcessId(), connectable.getElementId(), taskHandler);
            return;
        }
        List<String> variablesToFetch = this.getVariablesToFetch(idPropertyName, parameters);
        this.workers.add(this.client.newWorker().jobType(connectable.getTaskDefinition()).handler((JobHandler)taskHandler).name(this.workerId).fetchVariables(variablesToFetch));
    }

    private String getWorkflowDomainEntityIdPropertyName(Class<?> workflowAggregateClass) {
        if (workflowAggregateClass == null) {
            return null;
        }
        return Arrays.stream(workflowAggregateClass.getDeclaredFields()).filter(field -> field.getAnnotation(Id.class) != null).findFirst().map(field -> field.getName()).orElse(Arrays.stream(workflowAggregateClass.getDeclaredMethods()).filter(method -> method.getAnnotation(Id.class) != null).findFirst().map(this::propertyName).orElse(this.getWorkflowDomainEntityIdPropertyName(workflowAggregateClass.getSuperclass())));
    }

    private String propertyName(Method method) {
        if (method.getName().startsWith("get")) {
            if (method.getName().length() < 4) {
                return method.getName();
            }
            return method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        }
        if (method.getName().startsWith("is")) {
            if (method.getName().length() < 3) {
                return method.getName();
            }
            return method.getName().substring(2, 3).toLowerCase() + method.getName().substring(3);
        }
        return method.getName();
    }

    private List<String> getVariablesToFetch(String idPropertyName, List<MethodParameter> parameters) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(idPropertyName);
        parameters.stream().filter(parameter -> parameter instanceof ParameterVariables).flatMap(parameter -> ((ParameterVariables)parameter).getVariables().stream()).forEach(result::add);
        return result;
    }
}

