/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c8.wiring;

import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import java.util.HashMap;
import java.util.Map;
import org.camunda.community.vanillabp.c8.wiring.Camunda8TaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Camunda8UserTaskHandler
implements JobHandler {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8UserTaskHandler.class);
    private final Map<String, Camunda8TaskHandler> taskHandlers = new HashMap<String, Camunda8TaskHandler>();

    private String internalKey(String bpmnProcessId, String elementId) {
        return bpmnProcessId + "#" + elementId;
    }

    public void addTaskHandler(String bpmnProcessId, String elementId, Camunda8TaskHandler taskHandler) {
        String key = this.internalKey(bpmnProcessId, elementId);
        this.taskHandlers.put(key, taskHandler);
    }

    public void handle(JobClient client, ActivatedJob job) throws Exception {
        String key = this.internalKey(job.getBpmnProcessId(), job.getElementId());
        Camunda8TaskHandler taskHandler = this.taskHandlers.get(key);
        if (taskHandler == null) {
            logger.debug("No handler for BPMN process ID '{}' and element ID '{}' found!", (Object)job.getBpmnProcessId(), (Object)job.getElementId());
            return;
        }
        taskHandler.handle(client, job);
    }
}

