/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8;

import io.camunda.zeebe.spring.client.EnableZeebeClient;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.lifecycle.ZeebeClientLifecycle;
import io.vanillabp.camunda8.deployment.Camunda8DeploymentAdapter;
import io.vanillabp.camunda8.deployment.DeployedProcessRepository;
import io.vanillabp.camunda8.deployment.DeploymentRepository;
import io.vanillabp.camunda8.deployment.DeploymentResourceRepository;
import io.vanillabp.camunda8.deployment.DeploymentService;
import io.vanillabp.camunda8.service.Camunda8ProcessService;
import io.vanillabp.camunda8.wiring.Camunda8Connectable;
import io.vanillabp.camunda8.wiring.Camunda8TaskHandler;
import io.vanillabp.camunda8.wiring.Camunda8TaskWiring;
import io.vanillabp.camunda8.wiring.Camunda8UserTaskHandler;
import io.vanillabp.springboot.adapter.AdapterConfigurationBase;
import io.vanillabp.springboot.adapter.SpringDataUtil;
import io.vanillabp.springboot.parameters.MethodParameter;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.data.repository.CrudRepository;

@AutoConfigurationPackage(basePackageClasses={Camunda8AdapterConfiguration.class})
@EnableZeebeClient
public class Camunda8AdapterConfiguration
extends AdapterConfigurationBase<Camunda8ProcessService<?>> {
    @Value(value="${workerId}")
    private String workerId;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ZeebeClientLifecycle clientLifecycle;
    @Autowired
    private DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    @Autowired
    private DeploymentRepository deploymentRepository;
    @Autowired
    private DeployedProcessRepository deployedProcessRepository;
    @Autowired
    private DeploymentResourceRepository deploymentResourceRepository;

    @Bean
    public Camunda8DeploymentAdapter camunda8Adapter(DeploymentService deploymentService, Camunda8TaskWiring camunda8TaskWiring) {
        return new Camunda8DeploymentAdapter(deploymentService, this.clientLifecycle, camunda8TaskWiring);
    }

    @Bean
    public Camunda8TaskWiring camunda8TaskWiring(SpringDataUtil springDataUtil, Camunda8UserTaskHandler userTaskHandler, ObjectProvider<Camunda8TaskHandler> taskHandlers) {
        return new Camunda8TaskWiring(springDataUtil, this.applicationContext, this.workerId, userTaskHandler, taskHandlers, this.getConnectableServices());
    }

    @Bean
    public DeploymentService deploymentService(SpringDataUtil springDataUtil) {
        return new DeploymentService(springDataUtil, this.deploymentRepository, this.deploymentResourceRepository, this.deployedProcessRepository);
    }

    @Bean
    public Camunda8UserTaskHandler userTaskHandler() {
        return new Camunda8UserTaskHandler();
    }

    @Bean
    @Scope(value="prototype")
    public Camunda8TaskHandler camunda8TaskHandler(SpringDataUtil springDataUtil, CrudRepository<Object, String> repository, Camunda8Connectable.Type taskType, String taskDefinition, Object bean, Method method, List<MethodParameter> parameters, String idPropertyName) {
        return new Camunda8TaskHandler(taskType, this.deploymentService(springDataUtil), this.commandExceptionHandlingStrategy, repository, bean, method, parameters, idPropertyName);
    }

    @Bean
    @Scope(value="prototype")
    public <DE> Camunda8ProcessService<?> camundaProcessService(SpringDataUtil springDataUtil, InjectionPoint injectionPoint) throws Exception {
        return (Camunda8ProcessService)this.registerProcessService(springDataUtil, injectionPoint, (workflowDomainEntityRepository, workflowDomainEntityClass) -> new Camunda8ProcessService<Object>((CrudRepository<Object, String>)workflowDomainEntityRepository, domainEntity -> springDataUtil.getId(domainEntity), (Class<Object>)workflowDomainEntityClass));
    }
}

