/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.impl.BpmnModelInstanceImpl;
import io.camunda.zeebe.model.bpmn.impl.BpmnParser;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.BusinessRuleTask;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.SendTask;
import io.camunda.zeebe.model.bpmn.instance.ServiceTask;
import io.camunda.zeebe.model.bpmn.instance.UserTask;
import io.camunda.zeebe.spring.client.event.ClientStartedEvent;
import io.camunda.zeebe.spring.client.lifecycle.ZeebeClientLifecycle;
import io.vanillabp.camunda8.deployment.DeployedBpmn;
import io.vanillabp.camunda8.deployment.DeploymentService;
import io.vanillabp.camunda8.service.Camunda8ProcessService;
import io.vanillabp.camunda8.utils.HashCodeInputStream;
import io.vanillabp.camunda8.wiring.Camunda8TaskWiring;
import io.vanillabp.springboot.adapter.Connectable;
import io.vanillabp.springboot.adapter.ModuleAwareBpmnDeployment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StreamUtils;

@Transactional
public class Camunda8DeploymentAdapter
extends ModuleAwareBpmnDeployment {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8DeploymentAdapter.class);
    private final BpmnParser bpmnParser = new BpmnParser();
    private final Camunda8TaskWiring taskWiring;
    private final DeploymentService deploymentService;
    private final ZeebeClientLifecycle clientLifecycle;
    private ZeebeClient client;

    public Camunda8DeploymentAdapter(DeploymentService deploymentService, ZeebeClientLifecycle clientLifecycle, Camunda8TaskWiring taskWiring) {
        this.taskWiring = taskWiring;
        this.deploymentService = deploymentService;
        this.clientLifecycle = clientLifecycle;
    }

    protected Logger getLogger() {
        return logger;
    }

    @EventListener
    public void zeebeClientStarted(ClientStartedEvent event) {
        this.client = this.clientLifecycle.get();
        this.deployAllWorkflowModules();
        this.taskWiring.openWorkers();
    }

    protected void doDeployment(String workflowModuleId, Resource[] bpmns, Resource[] dmns, Resource[] cmms) throws Exception {
        int[] deploymentHashCode = new int[]{0};
        DeployResourceCommandStep1 deployResourceCommand = this.client.newDeployResourceCommand();
        Arrays.stream(dmns).forEach(resource -> {
            try (HashCodeInputStream inputStream = new HashCodeInputStream(resource.getInputStream(), deploymentHashCode[0]);){
                byte[] bytes = StreamUtils.copyToByteArray((InputStream)inputStream);
                deploymentHashCode[0] = inputStream.getTotalHashCode();
                deployResourceCommand.addResourceBytes(bytes, resource.getFilename());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        });
        HashMap deployedProcesses = new HashMap();
        boolean[] hasDeployables = new boolean[]{false};
        Optional<DeployResourceCommandStep1.DeployResourceCommandStep2> deploymentCommand = Arrays.stream(bpmns).map(resource -> {
            DeployResourceCommandStep1.DeployResourceCommandStep2 deployResourceCommandStep2;
            HashCodeInputStream inputStream = new HashCodeInputStream(resource.getInputStream(), deploymentHashCode[0]);
            try {
                logger.info("About to deploy '{}' of workflow-module '{}'", (Object)resource.getFilename(), (Object)workflowModuleId);
                BpmnModelInstanceImpl model = this.bpmnParser.parseModelFromStream((InputStream)inputStream);
                DeployedBpmn bpmn = this.deploymentService.addBpmn((BpmnModelInstance)model, inputStream.hashCode(), resource.getDescription());
                this.processBpmnModel(workflowModuleId, deployedProcesses, bpmn, model);
                deploymentHashCode[0] = inputStream.getTotalHashCode();
                hasDeployables[0] = true;
                deployResourceCommandStep2 = deployResourceCommand.addProcessModel((BpmnModelInstance)model, resource.getFilename());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            inputStream.close();
            return deployResourceCommandStep2;
        }).filter(Objects::nonNull).reduce((first, second) -> second);
        if (hasDeployables[0]) {
            DeploymentEvent deployedResources = deploymentCommand.map(command -> (DeploymentEvent)command.send().join()).orElseThrow();
            deployedResources.getProcesses().stream().map(process -> this.deploymentService.addProcess(deploymentHashCode[0], (io.camunda.zeebe.client.api.response.Process)process, (DeployedBpmn)deployedProcesses.get(process.getBpmnProcessId())).getDefinitionKey()).collect(Collectors.toList());
        }
        this.deploymentService.getBpmnNotOfPackage(deploymentHashCode[0]).stream().forEach(bpmn -> {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bpmn.getResource());){
                logger.info("About to verify old BPMN '{}' of workflow-module '{}'", (Object)bpmn.getResourceName(), (Object)workflowModuleId);
                BpmnModelInstanceImpl model = this.bpmnParser.parseModelFromStream((InputStream)inputStream);
                this.processBpmnModel(workflowModuleId, deployedProcesses, (DeployedBpmn)bpmn, model);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        });
    }

    private void processBpmnModel(String workflowModuleId, Map<String, DeployedBpmn> deployedProcesses, DeployedBpmn bpmn, BpmnModelInstanceImpl model) {
        this.taskWiring.accept(this.client);
        Camunda8ProcessService[] processService = new Camunda8ProcessService[]{null};
        model.getModelElementsByType(Process.class).stream().filter(Process::isExecutable).peek(process -> {
            processService[0] = (Camunda8ProcessService)this.taskWiring.wireService(workflowModuleId, process.getId());
            deployedProcesses.put(process.getId(), bpmn);
        }).flatMap(process -> Stream.of(this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)ServiceTask.class), this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)BusinessRuleTask.class), this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)SendTask.class), this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)UserTask.class), this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)IntermediateThrowEvent.class), this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)EndEvent.class)).flatMap(i -> i)).forEach(connectable -> this.taskWiring.wireTask(processService[0], (Connectable)connectable));
    }
}

