/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8;

import io.camunda.zeebe.spring.client.EnableZeebeClient;
import io.camunda.zeebe.spring.client.config.ZeebeClientStarterAutoConfiguration;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.lifecycle.ZeebeClientLifecycle;
import io.vanillabp.camunda8.deployment.Camunda8DeploymentAdapter;
import io.vanillabp.camunda8.deployment.DeploymentRepository;
import io.vanillabp.camunda8.deployment.DeploymentResourceRepository;
import io.vanillabp.camunda8.deployment.DeploymentService;
import io.vanillabp.camunda8.service.Camunda8ProcessService;
import io.vanillabp.camunda8.wiring.Camunda8Connectable;
import io.vanillabp.camunda8.wiring.Camunda8TaskHandler;
import io.vanillabp.camunda8.wiring.Camunda8TaskWiring;
import io.vanillabp.camunda8.wiring.Camunda8UserTaskHandler;
import io.vanillabp.springboot.adapter.AdapterConfigurationBase;
import io.vanillabp.springboot.adapter.SpringDataUtil;
import io.vanillabp.springboot.adapter.VanillaBpProperties;
import io.vanillabp.springboot.parameters.MethodParameter;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.data.repository.CrudRepository;

@AutoConfigurationPackage(basePackageClasses={Camunda8AdapterConfiguration.class})
@AutoConfigureBefore(value={ZeebeClientStarterAutoConfiguration.class})
@EnableZeebeClient
public class Camunda8AdapterConfiguration
extends AdapterConfigurationBase<Camunda8ProcessService<?>> {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8AdapterConfiguration.class);
    public static final String ADAPTER_ID = "camunda8";
    @Value(value="${workerId}")
    private String workerId;
    @Autowired
    private SpringDataUtil springDataUtil;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ZeebeClientLifecycle clientLifecycle;
    @Autowired
    private DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    @Autowired
    private DeploymentRepository deploymentRepository;
    @Autowired
    private DeploymentResourceRepository deploymentResourceRepository;

    @PostConstruct
    public void init() {
        logger.debug("Will use SpringDataUtil class '{}'", (Object)AopProxyUtils.ultimateTargetClass((Object)this.springDataUtil));
    }

    public String getAdapterId() {
        return ADAPTER_ID;
    }

    @Bean
    public Camunda8DeploymentAdapter camunda8Adapter(VanillaBpProperties properties, DeploymentService deploymentService, Camunda8TaskWiring camunda8TaskWiring) {
        return new Camunda8DeploymentAdapter(properties, deploymentService, this.clientLifecycle, camunda8TaskWiring);
    }

    @Bean
    public Camunda8TaskWiring camunda8TaskWiring(SpringDataUtil springDataUtil, Camunda8UserTaskHandler userTaskHandler, ObjectProvider<Camunda8TaskHandler> taskHandlers) {
        return new Camunda8TaskWiring(springDataUtil, this.applicationContext, this.workerId, userTaskHandler, taskHandlers, this.getConnectableServices());
    }

    @Bean
    public DeploymentService deploymentService(SpringDataUtil springDataUtil) {
        return new DeploymentService(this.deploymentRepository, this.deploymentResourceRepository);
    }

    @Bean
    public Camunda8UserTaskHandler userTaskHandler() {
        return new Camunda8UserTaskHandler(this.workerId);
    }

    @Bean
    @Scope(value="prototype")
    public Camunda8TaskHandler camunda8TaskHandler(SpringDataUtil springDataUtil, CrudRepository<Object, Object> repository, Camunda8Connectable.Type taskType, String taskDefinition, Object bean, Method method, List<MethodParameter> parameters, String idPropertyName) {
        return new Camunda8TaskHandler(taskType, this.commandExceptionHandlingStrategy, repository, bean, method, parameters, idPropertyName);
    }

    public <DE> Camunda8ProcessService<?> newProcessServiceImplementation(SpringDataUtil springDataUtil, Class<DE> workflowAggregateClass, Class<?> workflowAggregateIdClass, CrudRepository<DE, Object> workflowAggregateRepository) {
        Camunda8ProcessService<Object> result = new Camunda8ProcessService<Object>(workflowAggregateRepository, workflowAggregate -> springDataUtil.getId(workflowAggregate), workflowAggregateClass);
        this.putConnectableService(workflowAggregateClass, result);
        return result;
    }
}

