/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.wiring;

import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.CommandWrapper;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.vanillabp.camunda8.wiring.Camunda8Connectable;
import io.vanillabp.spi.service.TaskEvent;
import io.vanillabp.spi.service.TaskException;
import io.vanillabp.springboot.adapter.MultiInstance;
import io.vanillabp.springboot.adapter.TaskHandlerBase;
import io.vanillabp.springboot.adapter.wiring.WorkflowAggregateCache;
import io.vanillabp.springboot.parameters.MethodParameter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Transactional;

public class Camunda8TaskHandler
extends TaskHandlerBase
implements JobHandler {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8TaskHandler.class);
    private final DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final Camunda8Connectable.Type taskType;
    private final String idPropertyName;

    public Camunda8TaskHandler(Camunda8Connectable.Type taskType, DefaultCommandExceptionHandlingStrategy commandExceptionHandlingStrategy, CrudRepository<Object, Object> workflowAggregateRepository, Object bean, Method method, List<MethodParameter> parameters, String idPropertyName) {
        super(workflowAggregateRepository, bean, method, parameters);
        this.taskType = taskType;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.idPropertyName = idPropertyName;
    }

    protected Logger getLogger() {
        return logger;
    }

    @Transactional
    public void handle(JobClient client, ActivatedJob job) throws Exception {
        CommandWrapper command = null;
        try {
            Object businessKey = this.getVariable(job, this.idPropertyName);
            logger.trace("Will handle task '{}' of workflow '{}' ('{}') as job '{}'", new Object[]{job.getElementId(), job.getProcessInstanceKey(), job.getProcessDefinitionKey(), job.getKey()});
            AtomicBoolean taskIdRetrieved = new AtomicBoolean(false);
            Function<String, Object> multiInstanceSupplier = multiInstanceVariable -> this.getVariable(job, (String)multiInstanceVariable);
            WorkflowAggregateCache workflowAggregateCache = new WorkflowAggregateCache();
            super.execute(workflowAggregateCache, businessKey, true, new BiFunction[]{(args, param) -> this.processTaskParameter((Object[])args, (MethodParameter)param, taskParameter -> this.getVariable(job, (String)taskParameter)), (args, param) -> this.processTaskIdParameter((Object[])args, (MethodParameter)param, () -> {
                taskIdRetrieved.set(true);
                return Long.toHexString(job.getKey());
            }), (args, param) -> this.processTaskEventParameter((Object[])args, (MethodParameter)param, () -> TaskEvent.Event.CREATED), (args, param) -> this.processMultiInstanceIndexParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceTotalParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceElementParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceResolverParameter((Object[])args, (MethodParameter)param, () -> {
                if (workflowAggregateCache.workflowAggregate == null) {
                    workflowAggregateCache.workflowAggregate = this.workflowAggregateRepository.findById(businessKey).orElseThrow();
                }
                return workflowAggregateCache.workflowAggregate;
            }, multiInstanceSupplier)});
            if (this.taskType != Camunda8Connectable.Type.USERTASK && !taskIdRetrieved.get()) {
                command = this.createCompleteCommand(client, job, workflowAggregateCache.workflowAggregate);
            }
        }
        catch (TaskException bpmnError) {
            command = this.createThrowErrorCommand(client, job, bpmnError);
        }
        catch (Exception e) {
            logger.error("Failed to execute job '{}'", (Object)job.getKey(), (Object)e);
            command = this.createFailedCommand(client, job, e);
        }
        if (command != null) {
            command.executeAsync();
        }
    }

    protected Object getMultiInstanceElement(String name, Function<String, Object> multiInstanceSupplier) {
        return multiInstanceSupplier.apply(name);
    }

    protected Integer getMultiInstanceIndex(String name, Function<String, Object> multiInstanceSupplier) {
        return (Integer)multiInstanceSupplier.apply(name + "_index") - 1;
    }

    protected Integer getMultiInstanceTotal(String name, Function<String, Object> multiInstanceSupplier) {
        return (Integer)multiInstanceSupplier.apply(name + "_total");
    }

    protected MultiInstance<Object> getMultiInstance(String name, Function<String, Object> multiInstanceSupplier) {
        return new MultiInstance(this.getMultiInstanceElement(name, multiInstanceSupplier), this.getMultiInstanceTotal(name, multiInstanceSupplier).intValue(), this.getMultiInstanceIndex(name, multiInstanceSupplier).intValue());
    }

    private Object getVariable(ActivatedJob job, String name) {
        return job.getVariablesAsMap().get(name);
    }

    public CommandWrapper createCompleteCommand(JobClient jobClient, ActivatedJob job, Object workflowAggregateId) {
        CompleteJobCommandStep1 completeCommand = jobClient.newCompleteCommand(job.getKey());
        if (workflowAggregateId != null) {
            completeCommand = completeCommand.variables(workflowAggregateId);
        }
        return new CommandWrapper((FinalCommandStep)completeCommand, job, (CommandExceptionHandlingStrategy)this.commandExceptionHandlingStrategy);
    }

    private CommandWrapper createThrowErrorCommand(JobClient jobClient, ActivatedJob job, TaskException bpmnError) {
        return new CommandWrapper((FinalCommandStep)jobClient.newThrowErrorCommand(job.getKey()).errorCode(bpmnError.getErrorCode()).errorMessage(bpmnError.getErrorName()), job, (CommandExceptionHandlingStrategy)this.commandExceptionHandlingStrategy);
    }

    private CommandWrapper createFailedCommand(JobClient jobClient, ActivatedJob job, Exception e) {
        return new CommandWrapper((FinalCommandStep)jobClient.newFailCommand(job).retries(0).errorMessage(e.getMessage()), job, (CommandExceptionHandlingStrategy)this.commandExceptionHandlingStrategy);
    }
}

