/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.impl.BpmnModelInstanceImpl;
import io.camunda.zeebe.model.bpmn.impl.BpmnParser;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.BusinessRuleTask;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.SendTask;
import io.camunda.zeebe.model.bpmn.instance.ServiceTask;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.UserTask;
import io.camunda.zeebe.spring.client.event.ZeebeClientCreatedEvent;
import io.vanillabp.camunda8.deployment.DeployedBpmn;
import io.vanillabp.camunda8.deployment.DeploymentService;
import io.vanillabp.camunda8.service.Camunda8ProcessService;
import io.vanillabp.camunda8.utils.HashCodeInputStream;
import io.vanillabp.camunda8.wiring.Camunda8Connectable;
import io.vanillabp.camunda8.wiring.Camunda8TaskWiring;
import io.vanillabp.springboot.adapter.ModuleAwareBpmnDeployment;
import io.vanillabp.springboot.adapter.VanillaBpProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StreamUtils;

@Transactional
public class Camunda8DeploymentAdapter
extends ModuleAwareBpmnDeployment {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8DeploymentAdapter.class);
    private final BpmnParser bpmnParser = new BpmnParser();
    private final Camunda8TaskWiring taskWiring;
    private final DeploymentService deploymentService;
    private final String applicationName;
    private ZeebeClient client;

    public Camunda8DeploymentAdapter(String applicationName, VanillaBpProperties properties, DeploymentService deploymentService, Camunda8TaskWiring taskWiring) {
        super(properties);
        this.taskWiring = taskWiring;
        this.deploymentService = deploymentService;
        this.applicationName = applicationName;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected String getAdapterId() {
        return "camunda8";
    }

    @EventListener
    public void zeebeClientCreated(ZeebeClientCreatedEvent event) {
        this.client = event.getClient();
        this.deployAllWorkflowModules();
        this.taskWiring.openWorkers();
    }

    protected void doDeployment(String workflowModuleId, Resource[] bpmns, Resource[] dmns, Resource[] cmms) throws Exception {
        int[] deploymentHashCode = new int[]{0};
        DeployResourceCommandStep1 deployResourceCommand = this.client.newDeployResourceCommand();
        Arrays.stream(dmns).forEach(resource -> {
            try (HashCodeInputStream inputStream = new HashCodeInputStream(resource.getInputStream(), deploymentHashCode[0]);){
                byte[] bytes = StreamUtils.copyToByteArray((InputStream)inputStream);
                deploymentHashCode[0] = inputStream.getTotalHashCode();
                deployResourceCommand.addResourceBytes(bytes, resource.getFilename());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        });
        HashMap deployedProcesses = new HashMap();
        boolean[] hasDeployables = new boolean[]{false};
        Optional<DeployResourceCommandStep1.DeployResourceCommandStep2> deploymentCommand = Arrays.stream(bpmns).map(resource -> {
            DeployResourceCommandStep1.DeployResourceCommandStep2 deployResourceCommandStep2;
            HashCodeInputStream inputStream = new HashCodeInputStream(resource.getInputStream(), deploymentHashCode[0]);
            try {
                logger.info("About to deploy '{}' of workflow-module '{}'", (Object)resource.getFilename(), (Object)(workflowModuleId == null ? "default" : workflowModuleId));
                BpmnModelInstanceImpl model = this.bpmnParser.parseModelFromStream((InputStream)inputStream);
                DeployedBpmn bpmn = this.deploymentService.addBpmn((BpmnModelInstance)model, inputStream.hashCode(), resource.getDescription());
                this.processBpmnModel(workflowModuleId, deployedProcesses, bpmn, model, false);
                deploymentHashCode[0] = inputStream.getTotalHashCode();
                hasDeployables[0] = true;
                deployResourceCommandStep2 = deployResourceCommand.addProcessModel((BpmnModelInstance)model, resource.getFilename());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            inputStream.close();
            return deployResourceCommandStep2;
        }).filter(Objects::nonNull).reduce((first, second) -> second);
        if (hasDeployables[0]) {
            String tenantId = workflowModuleId == null ? this.applicationName : workflowModuleId;
            DeploymentEvent deployedResources = deploymentCommand.map(command -> tenantId == null ? command : (DeployResourceCommandStep1.DeployResourceCommandStep2)command.tenantId(tenantId)).map(command -> (DeploymentEvent)command.send().join()).orElseThrow();
            deployedResources.getProcesses().forEach(process -> this.deploymentService.addProcess(deploymentHashCode[0], (io.camunda.zeebe.client.api.response.Process)process, (DeployedBpmn)deployedProcesses.get(process.getBpmnProcessId())));
        }
        this.deploymentService.getBpmnNotOfPackage(deploymentHashCode[0]).forEach(bpmn -> {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bpmn.getResource());){
                logger.info("About to verify old BPMN '{}' of workflow-module '{}'", (Object)bpmn.getResourceName(), (Object)(workflowModuleId == null ? "default" : workflowModuleId));
                BpmnModelInstanceImpl model = this.bpmnParser.parseModelFromStream((InputStream)inputStream);
                this.processBpmnModel(workflowModuleId, deployedProcesses, (DeployedBpmn)bpmn, model, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        });
    }

    private void processBpmnModel(String workflowModuleId, Map<String, DeployedBpmn> deployedProcesses, DeployedBpmn bpmn, BpmnModelInstanceImpl model, boolean oldVersionBpmn) {
        this.taskWiring.accept(this.client);
        Camunda8ProcessService[] processService = new Camunda8ProcessService[]{null};
        model.getModelElementsByType(Process.class).stream().filter(Process::isExecutable).peek(process -> {
            Collection startEvents = model.getModelElementsByType(StartEvent.class);
            List messageBasedStartEventsMessageNames = startEvents.stream().filter(startEvent -> startEvent.getParentElement().equals(process)).map(startEvent -> startEvent.getChildElementsByType(MessageEventDefinition.class)).filter(eventDefinitions -> !eventDefinitions.isEmpty()).map(eventDefinitions -> ((MessageEventDefinition)eventDefinitions.iterator().next()).getMessage().getName()).collect(Collectors.toList());
            List signalBasedStartEventsSignalNames = startEvents.stream().filter(startEvent -> startEvent.getParentElement().equals(process)).map(startEvent -> startEvent.getChildElementsByType(SignalEventDefinition.class)).filter(eventDefinitions -> !eventDefinitions.isEmpty()).map(eventDefinitions -> ((SignalEventDefinition)eventDefinitions.iterator().next()).getSignal().getName()).collect(Collectors.toList());
            processService[0] = (Camunda8ProcessService)this.taskWiring.wireService(workflowModuleId, process.getId(), oldVersionBpmn ? null : messageBasedStartEventsMessageNames, oldVersionBpmn ? null : signalBasedStartEventsSignalNames);
            deployedProcesses.put(process.getId(), bpmn);
        }).flatMap(process -> Stream.of(this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)ServiceTask.class), this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)BusinessRuleTask.class), this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)SendTask.class), this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)UserTask.class), this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)IntermediateThrowEvent.class), this.taskWiring.connectablesForType((Process)process, model, (Class<? extends BaseElement>)EndEvent.class)).flatMap(i -> i)).forEach(connectable -> this.taskWiring.wireTask(workflowModuleId, processService[0], (Camunda8Connectable)connectable));
    }
}

