/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment;

import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.vanillabp.camunda8.deployment.DeployedBpmn;
import io.vanillabp.camunda8.deployment.DeployedProcess;
import io.vanillabp.camunda8.deployment.Deployment;
import io.vanillabp.camunda8.deployment.DeploymentRepository;
import io.vanillabp.camunda8.deployment.DeploymentResourceRepository;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;

public class DeploymentService {
    private final DeploymentRepository deploymentRepository;
    private final DeploymentResourceRepository deploymentResourceRepository;

    public DeploymentService(DeploymentRepository deploymentRepository, DeploymentResourceRepository deploymentResourceRepository) {
        this.deploymentRepository = deploymentRepository;
        this.deploymentResourceRepository = deploymentResourceRepository;
    }

    public DeployedBpmn addBpmn(BpmnModelInstance model, int fileId, String resourceName) {
        Optional previous = this.deploymentResourceRepository.findById(fileId);
        if (previous.isPresent()) {
            return (DeployedBpmn)previous.get();
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)model);
        DeployedBpmn bpmn = new DeployedBpmn();
        bpmn.setFileId(fileId);
        bpmn.setResource(outStream.toByteArray());
        bpmn.setResourceName(resourceName);
        return (DeployedBpmn)this.deploymentResourceRepository.save(bpmn);
    }

    public DeployedProcess addProcess(int packageId, Process camunda8DeployedProcess, DeployedBpmn bpmn) {
        long versionedId = camunda8DeployedProcess.getProcessDefinitionKey();
        Optional<Deployment> previous = this.deploymentRepository.findByDefinitionKey(versionedId);
        if (previous.isPresent() && previous.get().getPackageId() == packageId) {
            return (DeployedProcess)previous.get();
        }
        DeployedProcess deployedProcess = new DeployedProcess();
        deployedProcess.setDefinitionKey(versionedId);
        deployedProcess.setVersion(camunda8DeployedProcess.getVersion());
        deployedProcess.setPackageId(packageId);
        deployedProcess.setBpmnProcessId(camunda8DeployedProcess.getBpmnProcessId());
        deployedProcess.setDeployedResource(bpmn);
        deployedProcess.setPublishedAt(OffsetDateTime.now());
        return (DeployedProcess)this.deploymentRepository.save(deployedProcess);
    }

    public List<DeployedBpmn> getBpmnNotOfPackage(int packageId) {
        return this.deploymentResourceRepository.findByTypeAndDeployments_packageIdNot("BPMN", packageId).stream().distinct().toList();
    }
}

