/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.service;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.PublishMessageCommandStep1;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.vanillabp.springboot.adapter.AdapterAwareProcessService;
import io.vanillabp.springboot.adapter.ProcessServiceImplementation;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.MANDATORY)
public class Camunda8ProcessService<DE>
implements ProcessServiceImplementation<DE> {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8ProcessService.class);
    private final CrudRepository<DE, Object> workflowAggregateRepository;
    private final Class<DE> workflowAggregateClass;
    private final Function<DE, Object> getWorkflowAggregateId;
    private final String applicationName;
    private AdapterAwareProcessService<DE> parent;
    private ZeebeClient client;

    public Camunda8ProcessService(String applicationName, CrudRepository<DE, Object> workflowAggregateRepository, Function<DE, Object> getWorkflowAggregateId, Class<DE> workflowAggregateClass) {
        this.applicationName = applicationName;
        this.workflowAggregateRepository = workflowAggregateRepository;
        this.workflowAggregateClass = workflowAggregateClass;
        this.getWorkflowAggregateId = getWorkflowAggregateId;
    }

    public void setParent(AdapterAwareProcessService<DE> parent) {
        this.parent = parent;
    }

    public void wire(ZeebeClient client, String workflowModuleId, String bpmnProcessId, boolean isPrimary, Collection<String> messageBasedStartEventsMessageNames, Collection<String> signalBasedStartEventsSignalNames) {
        if (this.parent == null) {
            throw new RuntimeException("Not yet wired! If this occurs dependency of either VanillaBP Spring Boot support or Camunda8 adapter was changed introducing this lack of wiring. Please report a Github issue!");
        }
        this.client = client;
        this.parent.wire("camunda8", workflowModuleId, bpmnProcessId, isPrimary, messageBasedStartEventsMessageNames, signalBasedStartEventsSignalNames);
    }

    public Class<DE> getWorkflowAggregateClass() {
        return this.workflowAggregateClass;
    }

    public CrudRepository<DE, Object> getWorkflowAggregateRepository() {
        return this.workflowAggregateRepository;
    }

    public DE startWorkflow(DE workflowAggregate) throws Exception {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        String tenantId = this.parent.getWorkflowModuleId() == null ? this.applicationName : this.parent.getWorkflowModuleId();
        CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 command = this.client.newCreateInstanceCommand().bpmnProcessId(this.parent.getPrimaryBpmnProcessId()).latestVersion().variables(attachedAggregate);
        (tenantId == null ? command : (CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3)command.tenantId(tenantId)).send().get(10L, TimeUnit.SECONDS);
        return (DE)attachedAggregate;
    }

    public DE correlateMessage(DE workflowAggregate, String messageName) {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        Object correlationId = this.getWorkflowAggregateId.apply(workflowAggregate);
        this.correlateMessage(workflowAggregate, messageName, correlationId.toString());
        return (DE)attachedAggregate;
    }

    public DE correlateMessage(DE workflowAggregate, Object message) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName());
    }

    public DE correlateMessage(DE workflowAggregate, String messageName, String correlationId) {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        String tenantId = this.parent.getWorkflowModuleId() == null ? this.applicationName : this.parent.getWorkflowModuleId();
        PublishMessageCommandStep1.PublishMessageCommandStep3 command = this.client.newPublishMessageCommand().messageName(messageName).correlationKey(correlationId).variables(attachedAggregate);
        long messageKey = ((PublishMessageResponse)(tenantId == null ? command : (PublishMessageCommandStep1.PublishMessageCommandStep3)command.tenantId(tenantId)).send().join()).getMessageKey();
        logger.trace("Correlated message '{}' using correlation-id '{}' for process '{}' as '{}'", new Object[]{messageName, correlationId, this.parent.getPrimaryBpmnProcessId(), messageKey});
        return (DE)attachedAggregate;
    }

    public DE correlateMessage(DE workflowAggregate, Object message, String correlationId) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName(), correlationId);
    }

    public DE completeTask(DE workflowAggregate, String taskId) {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        this.client.newCompleteCommand(Long.parseLong(taskId, 16)).variables(attachedAggregate).send().join();
        logger.trace("Complete usertask '{}' for process '{}'", (Object)taskId, (Object)this.parent.getPrimaryBpmnProcessId());
        return (DE)attachedAggregate;
    }

    public DE completeUserTask(DE workflowAggregate, String taskId) {
        return this.completeTask(workflowAggregate, taskId);
    }

    public DE cancelTask(DE workflowAggregate, String taskId, String errorCode) {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        this.client.newThrowErrorCommand(Long.parseLong(taskId)).errorCode(errorCode).send().join();
        logger.trace("Complete usertask '{}' for process '{}'", (Object)taskId, (Object)this.parent.getPrimaryBpmnProcessId());
        return (DE)attachedAggregate;
    }

    public DE cancelUserTask(DE workflowAggregate, String taskId, String errorCode) {
        return this.cancelTask(workflowAggregate, taskId, errorCode);
    }
}

