/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HashCodeInputStream
extends InputStream {
    private final InputStream delegate;
    private int hashCode;
    private int totalHashCode;
    private int markedHashCode;

    public HashCodeInputStream(InputStream delegate) {
        this(delegate, 0);
    }

    public HashCodeInputStream(InputStream delegate, int previousHashCode) {
        this.delegate = delegate;
        this.totalHashCode = previousHashCode;
    }

    @Override
    public int read() throws IOException {
        int read = this.delegate.read();
        this.hashCode = 31 * this.hashCode + read;
        this.totalHashCode = 31 * this.totalHashCode + read;
        return read;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int getTotalHashCode() {
        return this.totalHashCode;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.markedHashCode = this.hashCode;
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.hashCode = this.markedHashCode;
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return this.delegate.transferTo(out);
    }
}

