/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment;

import io.vanillabp.camunda8.deployment.Deployment;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.util.List;

@Entity
@Table(name="CAMUNDA8_RESOURCES")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="C8R_TYPE")
public abstract class DeploymentResource {
    @Id
    @Column(name="C8R_ID")
    private int fileId;
    @Version
    @Column(name="C8R_RECORD_VERSION")
    private int recordVersion;
    @Column(name="C8R_RESOURCE_NAME")
    private String resourceName;
    @OneToMany(mappedBy="deployedResource", fetch=FetchType.LAZY)
    private List<Deployment> deployments;
    @Lob
    @Column(name="C8R_RESOURCE")
    private byte[] resource;
    @Column(name="C8R_TYPE", updatable=false, insertable=false)
    private String type;

    public int getFileId() {
        return this.fileId;
    }

    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public byte[] getResource() {
        return this.resource;
    }

    public void setResource(byte[] resource) {
        this.resource = resource;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public List<Deployment> getDeployments() {
        return this.deployments;
    }

    public void setDeployments(List<Deployment> deployments) {
        this.deployments = deployments;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    public void setRecordVersion(int recordVersion) {
        this.recordVersion = recordVersion;
    }

    public int hashCode() {
        return this.getFileId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeploymentResource)) {
            return false;
        }
        DeploymentResource other = (DeploymentResource)obj;
        return this.getFileId() == other.getFileId();
    }
}

