/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment;

import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.vanillabp.camunda8.deployment.DeployedBpmn;
import io.vanillabp.camunda8.deployment.DeployedProcess;
import io.vanillabp.camunda8.deployment.Deployment;
import io.vanillabp.camunda8.deployment.DeploymentRepository;
import io.vanillabp.camunda8.deployment.DeploymentResourceRepository;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DeploymentService {
    private final DeploymentRepository deploymentRepository;
    private final DeploymentResourceRepository deploymentResourceRepository;

    public DeploymentService(DeploymentRepository deploymentRepository, DeploymentResourceRepository deploymentResourceRepository) {
        this.deploymentRepository = deploymentRepository;
        this.deploymentResourceRepository = deploymentResourceRepository;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Retryable(retryFor={OptimisticLockingFailureException.class, ObjectOptimisticLockingFailureException.class}, maxAttempts=100, backoff=@Backoff(delay=100L, maxDelay=500L))
    public DeployedBpmn addBpmn(BpmnModelInstance model, int fileId, String resourceName) {
        Optional previous = this.deploymentResourceRepository.findById(fileId);
        if (previous.isPresent()) {
            return (DeployedBpmn)previous.get();
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)model);
        DeployedBpmn bpmn = new DeployedBpmn();
        bpmn.setFileId(fileId);
        bpmn.setResource(outStream.toByteArray());
        bpmn.setResourceName(resourceName);
        return (DeployedBpmn)this.deploymentResourceRepository.save(bpmn);
    }

    @Recover
    public DeployedBpmn recoverAddBpmn(OptimisticLockingFailureException exception, BpmnModelInstance model, int fileId, String resourceName) {
        return this.recoverAddBpmn(exception, model, fileId, resourceName);
    }

    @Recover
    public DeployedBpmn recoverAddBpmn(ObjectOptimisticLockingFailureException exception, BpmnModelInstance model, int fileId, String resourceName) {
        return this.recoverAddBpmn(exception, model, fileId, resourceName);
    }

    private DeployedBpmn recoverAddBpmn(Exception exception, BpmnModelInstance model, int fileId, String resourceName) {
        throw new RuntimeException("Could not save BPMN '" + resourceName + "' in local DB due to stale OptimisticLockingFailureException", exception);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Retryable(retryFor={OptimisticLockingFailureException.class, ObjectOptimisticLockingFailureException.class}, maxAttempts=100, backoff=@Backoff(delay=100L, maxDelay=500L))
    public DeployedProcess addProcess(int packageId, Process camunda8DeployedProcess, DeployedBpmn bpmn) {
        long versionedId = camunda8DeployedProcess.getProcessDefinitionKey();
        Optional<Deployment> previous = this.deploymentRepository.findByDefinitionKey(versionedId);
        if (previous.isPresent() && previous.get().getPackageId() == packageId) {
            return (DeployedProcess)previous.get();
        }
        DeployedProcess deployedProcess = new DeployedProcess();
        deployedProcess.setDefinitionKey(versionedId);
        deployedProcess.setVersion(camunda8DeployedProcess.getVersion());
        deployedProcess.setPackageId(packageId);
        deployedProcess.setBpmnProcessId(camunda8DeployedProcess.getBpmnProcessId());
        deployedProcess.setDeployedResource(bpmn);
        deployedProcess.setPublishedAt(OffsetDateTime.now());
        return (DeployedProcess)this.deploymentRepository.save(deployedProcess);
    }

    @Recover
    public DeployedProcess recoverAddProcess(OptimisticLockingFailureException exception, int packageId, Process camunda8DeployedProcess, DeployedBpmn bpmn) {
        return this.recoverAddProcess(exception, packageId, camunda8DeployedProcess, bpmn);
    }

    @Recover
    public DeployedProcess recoverAddProcess(ObjectOptimisticLockingFailureException exception, int packageId, Process camunda8DeployedProcess, DeployedBpmn bpmn) {
        return this.recoverAddProcess(exception, packageId, camunda8DeployedProcess, bpmn);
    }

    private DeployedProcess recoverAddProcess(Exception exception, int packageId, Process camunda8DeployedProcess, DeployedBpmn bpmn) {
        throw new RuntimeException("Could not save Process '" + camunda8DeployedProcess.getBpmnProcessId() + "' in local DB due to stale OptimisticLockingFailureException", exception);
    }

    public List<DeployedBpmn> getBpmnNotOfPackage(int packageId) {
        return this.deploymentResourceRepository.findByTypeAndDeployments_packageIdNot("BPMN", packageId).stream().distinct().toList();
    }
}

