/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.service;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.PublishMessageCommandStep1;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.vanillabp.camunda8.Camunda8VanillaBpProperties;
import io.vanillabp.camunda8.LoggingContext;
import io.vanillabp.camunda8.service.Camunda8TransactionProcessor;
import io.vanillabp.springboot.adapter.AdapterAwareProcessService;
import io.vanillabp.springboot.adapter.ProcessServiceImplementation;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Transactional(propagation=Propagation.MANDATORY)
public class Camunda8ProcessService<DE>
implements ProcessServiceImplementation<DE> {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8ProcessService.class);
    private final CrudRepository<DE, Object> workflowAggregateRepository;
    private final Class<DE> workflowAggregateClass;
    private final Function<DE, Object> getWorkflowAggregateId;
    private final Camunda8VanillaBpProperties camunda8Properties;
    private final ApplicationEventPublisher publisher;
    private AdapterAwareProcessService<DE> parent;
    private ZeebeClient client;

    public Camunda8ProcessService(Camunda8VanillaBpProperties camunda8Properties, ApplicationEventPublisher publisher, CrudRepository<DE, Object> workflowAggregateRepository, Function<DE, Object> getWorkflowAggregateId, Class<DE> workflowAggregateClass) {
        this.camunda8Properties = camunda8Properties;
        this.publisher = publisher;
        this.workflowAggregateRepository = workflowAggregateRepository;
        this.workflowAggregateClass = workflowAggregateClass;
        this.getWorkflowAggregateId = getWorkflowAggregateId;
    }

    public void setParent(AdapterAwareProcessService<DE> parent) {
        this.parent = parent;
    }

    public void wire(ZeebeClient client, String workflowModuleId, String bpmnProcessId, boolean isPrimary, Collection<String> messageBasedStartEventsMessageNames, Collection<String> signalBasedStartEventsSignalNames) {
        if (this.parent == null) {
            throw new RuntimeException("Not yet wired! If this occurs dependency of either VanillaBP Spring Boot support or Camunda8 adapter was changed introducing this lack of wiring. Please report a Github issue!");
        }
        this.client = client;
        this.parent.wire("camunda8", workflowModuleId, bpmnProcessId, isPrimary, messageBasedStartEventsMessageNames, signalBasedStartEventsSignalNames);
    }

    public Class<DE> getWorkflowAggregateClass() {
        return this.workflowAggregateClass;
    }

    public CrudRepository<DE, Object> getWorkflowAggregateRepository() {
        return this.workflowAggregateRepository;
    }

    public String getPrimaryBpmnProcessId() {
        return this.parent.getPrimaryBpmnProcessId();
    }

    public DE startWorkflow(DE workflowAggregate) throws Exception {
        return (DE)this.runInTransaction(workflowAggregate, attachedAggregate -> {
            String tenantId = this.camunda8Properties.getTenantId(this.parent.getWorkflowModuleId());
            CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 command = this.client.newCreateInstanceCommand().bpmnProcessId(this.parent.getPrimaryBpmnProcessId()).latestVersion().variables(attachedAggregate);
            try {
                (tenantId == null ? command : (CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3)command.tenantId(tenantId)).send().get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException("Starting workflow '" + this.parent.getPrimaryBpmnProcessId() + "\u2018 for aggregate '" + String.valueOf(attachedAggregate) + "' failed!", e);
            }
        }, "startWorkflow");
    }

    public DE correlateMessage(DE workflowAggregate, String messageName) {
        return (DE)this.runInTransaction(workflowAggregate, attachedAggregate -> {
            Object correlationId = this.getWorkflowAggregateId.apply(workflowAggregate);
            this.doCorrelateMessage(workflowAggregate, messageName, correlationId.toString());
        }, "correlateMessage");
    }

    public DE correlateMessage(DE workflowAggregate, Object message) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName());
    }

    public DE correlateMessage(DE workflowAggregate, String messageName, String correlationId) {
        return (DE)this.runInTransaction(workflowAggregate, attachedAggregate -> this.doCorrelateMessage(attachedAggregate, messageName, correlationId), "correlateMessage-by-correlationId");
    }

    private void doCorrelateMessage(DE attachedAggregate, String messageName, String correlationId) {
        String tenantId = this.camunda8Properties.getTenantId(this.parent.getWorkflowModuleId());
        PublishMessageCommandStep1.PublishMessageCommandStep3 command = this.client.newPublishMessageCommand().messageName(messageName).correlationKey(correlationId).variables(attachedAggregate);
        long messageKey = ((PublishMessageResponse)(tenantId == null ? command : (PublishMessageCommandStep1.PublishMessageCommandStep3)command.tenantId(tenantId)).send().join()).getMessageKey();
        logger.trace("Correlated message '{}' using correlation-id '{}' for process '{}' as '{}'", new Object[]{messageName, correlationId, this.parent.getPrimaryBpmnProcessId(), messageKey});
    }

    public DE correlateMessage(DE workflowAggregate, Object message, String correlationId) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName(), correlationId);
    }

    public DE completeTask(DE workflowAggregate, String taskId) {
        return (DE)this.runInTransaction(workflowAggregate, taskId, attachedAggregate -> {
            this.client.newCompleteCommand(Long.parseLong(taskId, 16)).variables(attachedAggregate).send().join();
            logger.trace("Complete task '{}' of process '{}'", (Object)taskId, (Object)this.parent.getPrimaryBpmnProcessId());
        }, "completeTask");
    }

    public DE completeUserTask(DE workflowAggregate, String taskId) {
        return (DE)this.runInTransaction(workflowAggregate, taskId, attachedAggregate -> {
            this.client.newCompleteCommand(Long.parseLong(taskId, 16)).variables(attachedAggregate).send().join();
            logger.trace("Complete user task '{}' of process '{}'", (Object)taskId, (Object)this.parent.getPrimaryBpmnProcessId());
        }, "completeUserTask");
    }

    public DE cancelTask(DE workflowAggregate, String taskId, String errorCode) {
        return (DE)this.runInTransaction(workflowAggregate, taskId, attachedAggregate -> {
            this.client.newThrowErrorCommand(Long.parseLong(taskId)).errorCode(errorCode).send().join();
            logger.trace("Complete task '{}' of process '{}'", (Object)taskId, (Object)this.parent.getPrimaryBpmnProcessId());
        }, "cancelTask");
    }

    public DE cancelUserTask(DE workflowAggregate, String taskId, String errorCode) {
        return this.cancelTask(workflowAggregate, taskId, errorCode);
    }

    private DE runInTransaction(DE workflowAggregate, Consumer<DE> runnable, String methodSignature) {
        return this.runInTransaction(workflowAggregate, null, runnable, methodSignature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DE runInTransaction(DE workflowAggregate, String taskIdToTestForAlreadyCompletedOrCancelled, Consumer<DE> runnable, String methodSignature) {
        try {
            Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
            Object aggregateId = this.getWorkflowAggregateId.apply(attachedAggregate);
            String bpmnProcessId = this.parent.getPrimaryBpmnProcessId();
            LoggingContext.setLoggingContext("camunda8", this.camunda8Properties.getTenantId(this.parent.getWorkflowModuleId()), this.parent.getWorkflowModuleId(), aggregateId.toString(), bpmnProcessId, taskIdToTestForAlreadyCompletedOrCancelled, null, null, null);
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                if (taskIdToTestForAlreadyCompletedOrCancelled != null) {
                    this.publisher.publishEvent((ApplicationEvent)new Camunda8TransactionProcessor.Camunda8TestForTaskAlreadyCompletedOrCancelled(methodSignature, () -> this.client.newUpdateTimeoutCommand(Long.parseUnsignedLong(taskIdToTestForAlreadyCompletedOrCancelled, 16)).timeout(Duration.ofMinutes(10L)).send().join(5L, TimeUnit.MINUTES), () -> "aggregate: " + String.valueOf(aggregateId) + "; bpmn-process-id: " + bpmnProcessId));
                }
                this.publisher.publishEvent((ApplicationEvent)new Camunda8TransactionProcessor.Camunda8CommandAfterTx(methodSignature, () -> runnable.accept(attachedAggregate), () -> "aggregate: " + String.valueOf(aggregateId) + "; bpmn-process-id: " + bpmnProcessId));
            } else {
                runnable.accept(attachedAggregate);
            }
            Object object = attachedAggregate;
            return (DE)object;
        }
        finally {
            LoggingContext.clearContext();
        }
    }
}

