/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.service;

import io.vanillabp.camunda8.service.Camunda8TransactionProcessor;
import io.vanillabp.spi.service.TaskException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
public class Camunda8TransactionAspect {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8TransactionAspect.class);
    public static final ThreadLocal<TaskHandlerActions> actions = ThreadLocal.withInitial(TaskHandlerActions::new);
    public static final ThreadLocal<RunDeferredInTransaction> runDeferredInTransaction = ThreadLocal.withInitial(RunDeferredInTransaction::new);
    private final ApplicationEventPublisher publisher;

    public Camunda8TransactionAspect(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public static void registerDeferredInTransaction(RunDeferredInTransactionSupplier[] argsSupplier, Runnable saveAggregateAfterWorkflowTask) {
        Camunda8TransactionAspect.runDeferredInTransaction.get().argsSupplier = argsSupplier;
        Camunda8TransactionAspect.runDeferredInTransaction.get().saveAggregateAfterWorkflowTask = saveAggregateAfterWorkflowTask;
    }

    public static void unregisterDeferredInTransaction() {
        Camunda8TransactionAspect.runDeferredInTransaction.get().argsSupplier = null;
        Camunda8TransactionAspect.runDeferredInTransaction.get().saveAggregateAfterWorkflowTask = null;
    }

    private void saveWorkflowAggregate() {
        Camunda8TransactionAspect.runDeferredInTransaction.get().saveAggregateAfterWorkflowTask.run();
    }

    @Around(value="@annotation(io.vanillabp.spi.service.WorkflowTask)")
    private Object checkForTransaction(ProceedingJoinPoint pjp) throws Throwable {
        String methodSignature = pjp.getSignature().toLongString();
        boolean isTxActive = TransactionSynchronizationManager.isActualTransactionActive();
        try {
            Map.Entry<Runnable, Supplier<String>> handlerCompletedCommand;
            Map.Entry<Runnable, Supplier<String>> handlerTestCommand;
            Object[] newArgs = this.runDeferredInTransactionArgsSupplier(pjp.getArgs());
            Object value = pjp.proceed(newArgs);
            this.saveWorkflowAggregate();
            if (isTxActive && Camunda8TransactionAspect.actions.get().testForTaskAlreadyCompletedOrCancelledCommand != null && (handlerTestCommand = Camunda8TransactionAspect.actions.get().testForTaskAlreadyCompletedOrCancelledCommand.get()) != null) {
                this.publisher.publishEvent((ApplicationEvent)new Camunda8TransactionProcessor.Camunda8TestForTaskAlreadyCompletedOrCancelled(methodSignature, handlerTestCommand.getKey(), handlerTestCommand.getValue()));
            }
            if (Camunda8TransactionAspect.actions.get().handlerCompletedCommand != null && (handlerCompletedCommand = Camunda8TransactionAspect.actions.get().handlerCompletedCommand.get()) != null) {
                if (isTxActive) {
                    this.publisher.publishEvent((ApplicationEvent)new Camunda8TransactionProcessor.Camunda8CommandAfterTx(methodSignature, handlerCompletedCommand.getKey(), handlerCompletedCommand.getValue()));
                } else {
                    try {
                        handlerCompletedCommand.getKey().run();
                    }
                    catch (Exception e) {
                        Supplier<String> description = handlerCompletedCommand.getValue();
                        if (description != null) {
                            logger.error("Could not execute '{}'! Manual action required!", (Object)description.get(), (Object)e);
                        }
                        logger.error("Manual action required due to:", (Throwable)e);
                    }
                }
            }
            return value;
        }
        catch (TaskException taskError) {
            block24: {
                Map.Entry<Runnable, Supplier<String>> handlerTestCommand;
                if (isTxActive && Camunda8TransactionAspect.actions.get().testForTaskAlreadyCompletedOrCancelledCommand != null && (handlerTestCommand = Camunda8TransactionAspect.actions.get().testForTaskAlreadyCompletedOrCancelledCommand.get()) != null) {
                    this.publisher.publishEvent((ApplicationEvent)new Camunda8TransactionProcessor.Camunda8TestForTaskAlreadyCompletedOrCancelled(methodSignature, handlerTestCommand.getKey(), handlerTestCommand.getValue()));
                }
                if (Camunda8TransactionAspect.actions.get().bpmnErrorCommand != null) {
                    Consumer<TaskException> runnable = Camunda8TransactionAspect.actions.get().bpmnErrorCommand.getKey();
                    Function<TaskException, String> description = Camunda8TransactionAspect.actions.get().bpmnErrorCommand.getValue();
                    if (isTxActive) {
                        this.publisher.publishEvent((ApplicationEvent)new Camunda8TransactionProcessor.Camunda8CommandAfterTx(methodSignature, () -> runnable.accept(taskError), () -> (String)description.apply(taskError)));
                    } else {
                        try {
                            runnable.accept(taskError);
                        }
                        catch (Exception e) {
                            if (description != null) {
                                logger.error("Could not execute '{}'! Manual action required!", (Object)description.apply(taskError), (Object)e);
                                break block24;
                            }
                            logger.error("Manual action required due to:", (Throwable)e);
                        }
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            block25: {
                Map.Entry<Runnable, Supplier<String>> handlerTestCommand;
                if (isTxActive && Camunda8TransactionAspect.actions.get().testForTaskAlreadyCompletedOrCancelledCommand != null && (handlerTestCommand = Camunda8TransactionAspect.actions.get().testForTaskAlreadyCompletedOrCancelledCommand.get()) != null) {
                    this.publisher.publishEvent((ApplicationEvent)new Camunda8TransactionProcessor.Camunda8TestForTaskAlreadyCompletedOrCancelled(methodSignature, handlerTestCommand.getKey(), handlerTestCommand.getValue()));
                }
                if (Camunda8TransactionAspect.actions.get().handlerFailedCommand != null) {
                    Consumer<Exception> runnable = Camunda8TransactionAspect.actions.get().handlerFailedCommand.getKey();
                    Function<Exception, String> description = Camunda8TransactionAspect.actions.get().handlerFailedCommand.getValue();
                    if (isTxActive) {
                        this.publisher.publishEvent((ApplicationEvent)new Camunda8TransactionProcessor.Camunda8CommandAfterTx(methodSignature, () -> runnable.accept(e), () -> (String)description.apply(e)));
                    } else {
                        try {
                            runnable.accept(e);
                        }
                        catch (Exception ie) {
                            if (description != null) {
                                logger.error("Could not execute '{}'! Manual action required!", (Object)description.apply(e), (Object)ie);
                                break block25;
                            }
                            logger.error("Manual action required due to:", (Throwable)ie);
                        }
                    }
                }
            }
            throw e;
        }
    }

    public static void clearCallbacks() {
        Camunda8TransactionAspect.actions.get().bpmnErrorCommand = null;
        Camunda8TransactionAspect.actions.get().handlerCompletedCommand = null;
        Camunda8TransactionAspect.actions.get().handlerFailedCommand = null;
        Camunda8TransactionAspect.actions.get().testForTaskAlreadyCompletedOrCancelledCommand = null;
    }

    private Object[] runDeferredInTransactionArgsSupplier(Object[] originalArgs) {
        if (originalArgs == null) {
            return null;
        }
        Object[] newArgs = new Object[originalArgs.length];
        for (int i = 0; i < originalArgs.length; ++i) {
            RunDeferredInTransactionSupplier supplier = Camunda8TransactionAspect.runDeferredInTransaction.get().argsSupplier[i];
            newArgs[i] = supplier != null ? supplier.get() : originalArgs[i];
        }
        return newArgs;
    }

    public static class RunDeferredInTransaction {
        public RunDeferredInTransactionSupplier[] argsSupplier;
        public Runnable saveAggregateAfterWorkflowTask;
    }

    public static interface RunDeferredInTransactionSupplier
    extends Supplier<Object> {
    }

    public static class TaskHandlerActions {
        public Supplier<Map.Entry<Runnable, Supplier<String>>> testForTaskAlreadyCompletedOrCancelledCommand;
        public Map.Entry<Consumer<TaskException>, Function<TaskException, String>> bpmnErrorCommand;
        public Map.Entry<Consumer<Exception>, Function<Exception, String>> handlerFailedCommand;
        public Supplier<Map.Entry<Runnable, Supplier<String>>> handlerCompletedCommand;
    }
}

