/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.wiring;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.model.bpmn.impl.BpmnModelInstanceImpl;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.UserTask;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeFormDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeLoopCharacteristics;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.vanillabp.camunda8.Camunda8VanillaBpProperties;
import io.vanillabp.camunda8.service.Camunda8ProcessService;
import io.vanillabp.camunda8.wiring.Camunda8Connectable;
import io.vanillabp.camunda8.wiring.Camunda8TaskHandler;
import io.vanillabp.camunda8.wiring.Camunda8UserTaskHandler;
import io.vanillabp.camunda8.wiring.parameters.Camunda8MethodParameterFactory;
import io.vanillabp.camunda8.wiring.parameters.ParameterVariables;
import io.vanillabp.spi.service.WorkflowTask;
import io.vanillabp.springboot.adapter.Connectable;
import io.vanillabp.springboot.adapter.SpringBeanUtil;
import io.vanillabp.springboot.adapter.SpringDataUtil;
import io.vanillabp.springboot.adapter.TaskWiringBase;
import io.vanillabp.springboot.parameters.MethodParameter;
import io.vanillabp.springboot.parameters.MethodParameterFactory;
import jakarta.persistence.Id;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.CrudRepository;

public class Camunda8TaskWiring
extends TaskWiringBase<Camunda8Connectable, Camunda8ProcessService<?>, Camunda8MethodParameterFactory>
implements Consumer<ZeebeClient> {
    private static final long TIMEOUT_100YEARS = 3153600000000L;
    private final String workerId;
    private final SpringDataUtil springDataUtil;
    private final ObjectProvider<Camunda8TaskHandler> taskHandlers;
    private final Collection<Camunda8ProcessService<?>> connectableServices;
    private final Camunda8UserTaskHandler userTaskHandler;
    private ZeebeClient client;
    private List<JobWorkerBuilderStep1.JobWorkerBuilderStep3> workers = new LinkedList<JobWorkerBuilderStep1.JobWorkerBuilderStep3>();
    private List<Camunda8TaskHandler> handlers = new LinkedList<Camunda8TaskHandler>();
    private Set<String> userTaskTenantIds = new HashSet<String>();
    private final Camunda8VanillaBpProperties camunda8Properties;

    public Camunda8TaskWiring(SpringDataUtil springDataUtil, ApplicationContext applicationContext, SpringBeanUtil springBeanUtil, String workerId, Camunda8VanillaBpProperties camunda8Properties, Camunda8UserTaskHandler userTaskHandler, ObjectProvider<Camunda8TaskHandler> taskHandlers, Collection<Camunda8ProcessService<?>> connectableServices) {
        super(applicationContext, springBeanUtil, (MethodParameterFactory)new Camunda8MethodParameterFactory());
        this.workerId = workerId;
        this.springDataUtil = springDataUtil;
        this.taskHandlers = taskHandlers;
        this.userTaskHandler = userTaskHandler;
        this.connectableServices = connectableServices;
        this.camunda8Properties = camunda8Properties;
    }

    protected Class<WorkflowTask> getAnnotationType() {
        return WorkflowTask.class;
    }

    @Override
    public void accept(ZeebeClient client) {
        this.client = client;
        this.handlers.forEach(handler -> handler.accept(client));
    }

    public void openWorkers() {
        this.userTaskTenantIds.stream().map(workflowModuleId -> {
            String tenantId = this.camunda8Properties.getTenantId((String)workflowModuleId);
            JobWorkerBuilderStep1.JobWorkerBuilderStep3 userTaskWorker = this.client.newWorker().jobType("io.camunda.zeebe:userTask").handler((JobHandler)this.userTaskHandler).timeout(3153600000000L).name(this.workerId);
            if (tenantId != null) {
                userTaskWorker.tenantId(tenantId);
            }
            Camunda8VanillaBpProperties.WorkerProperties workerProperties = this.camunda8Properties.getUserTaskWorkerProperties((String)workflowModuleId);
            workerProperties.applyToUserTaskWorker(userTaskWorker);
            return userTaskWorker;
        }).forEach(this.workers::add);
        this.workers.forEach(JobWorkerBuilderStep1.JobWorkerBuilderStep3::open);
    }

    public Stream<Camunda8Connectable> connectablesForType(Process process, BpmnModelInstanceImpl model, Class<? extends BaseElement> type) {
        Camunda8Connectable.Type kind = UserTask.class.isAssignableFrom(type) ? Camunda8Connectable.Type.USERTASK : Camunda8Connectable.Type.TASK;
        Stream<Camunda8Connectable> stream = model.getModelElementsByType(type).stream().filter(element -> Camunda8TaskWiring.getOwningProcess((ModelElementInstance)element).equals((Object)process)).map(element -> new Camunda8Connectable(process, element.getId(), kind, this.getTaskDefinition(kind, (BaseElement)element), (ZeebeLoopCharacteristics)element.getSingleExtensionElement(ZeebeLoopCharacteristics.class))).filter(connectable -> connectable.isExecutableProcess());
        if (kind == Camunda8Connectable.Type.USERTASK) {
            return stream;
        }
        return stream.filter(connectable -> connectable.getTaskDefinition() != null);
    }

    private String getTaskDefinition(Camunda8Connectable.Type kind, BaseElement element) {
        if (kind == Camunda8Connectable.Type.USERTASK) {
            ZeebeFormDefinition formDefinition = (ZeebeFormDefinition)element.getSingleExtensionElement(ZeebeFormDefinition.class);
            if (formDefinition == null) {
                return null;
            }
            return formDefinition.getFormKey();
        }
        ZeebeTaskDefinition taskDefinition = (ZeebeTaskDefinition)element.getSingleExtensionElement(ZeebeTaskDefinition.class);
        if (taskDefinition == null) {
            return null;
        }
        return taskDefinition.getType();
    }

    static Process getOwningProcess(ModelElementInstance element) {
        if (element instanceof Process) {
            return (Process)element;
        }
        ModelElementInstance parent = element.getParentElement();
        if (parent == null) {
            return null;
        }
        return Camunda8TaskWiring.getOwningProcess(parent);
    }

    protected <DE> Camunda8ProcessService<?> connectToBpms(String workflowModuleId, Class<DE> workflowAggregateClass, String bpmnProcessId, boolean isPrimary, Collection<String> messageBasedStartEventsMessageNames, Collection<String> signalBasedStartEventsSignalNames) {
        Camunda8ProcessService processService = this.connectableServices.stream().filter(service -> service.getWorkflowAggregateClass().equals(workflowAggregateClass)).findFirst().get();
        processService.wire(this.client, workflowModuleId, bpmnProcessId, isPrimary, messageBasedStartEventsMessageNames, signalBasedStartEventsSignalNames);
        return processService;
    }

    protected void connectToBpms(String workflowModuleId, Camunda8ProcessService<?> processService, Object bean, Camunda8Connectable connectable, Method method, List<MethodParameter> parameters) {
        CrudRepository<?, Object> repository = processService.getWorkflowAggregateRepository();
        String idPropertyName = this.getWorkflowAggregateIdPropertyName(processService.getWorkflowAggregateClass());
        String tenantId = this.camunda8Properties.getTenantId(workflowModuleId);
        Camunda8TaskHandler taskHandler = (Camunda8TaskHandler)this.taskHandlers.getObject(new Object[]{this.springDataUtil, repository, connectable.getType(), connectable.getTaskDefinition(), bean, method, parameters, idPropertyName, tenantId, workflowModuleId, processService.getPrimaryBpmnProcessId()});
        if (this.client != null) {
            taskHandler.accept(this.client);
        } else {
            this.handlers.add(taskHandler);
        }
        if (connectable.getType() == Camunda8Connectable.Type.USERTASK) {
            this.userTaskHandler.addTaskHandler(tenantId, connectable.getBpmnProcessId(), connectable.getElementId(), taskHandler);
            this.userTaskTenantIds.add(workflowModuleId);
            return;
        }
        List<String> variablesToFetch = this.getVariablesToFetch(idPropertyName, parameters);
        JobWorkerBuilderStep1.JobWorkerBuilderStep3 worker = this.client.newWorker().jobType(connectable.getTaskDefinition()).handler((JobHandler)taskHandler).name(this.workerId).fetchVariables(variablesToFetch);
        Camunda8VanillaBpProperties.WorkerProperties workerProperties = this.camunda8Properties.getWorkerProperties(workflowModuleId, connectable.getBpmnProcessId(), connectable.getTaskDefinition());
        workerProperties.applyToWorker(worker);
        this.workers.add(tenantId != null ? (JobWorkerBuilderStep1.JobWorkerBuilderStep3)worker.tenantId(tenantId) : worker);
    }

    private String getWorkflowAggregateIdPropertyName(Class<?> workflowAggregateClass) {
        if (workflowAggregateClass == null) {
            return null;
        }
        return Arrays.stream(workflowAggregateClass.getDeclaredFields()).filter(field -> field.getAnnotation(Id.class) != null).findFirst().map(Field::getName).orElse(Arrays.stream(workflowAggregateClass.getDeclaredMethods()).filter(method -> method.getAnnotation(Id.class) != null).findFirst().map(this::propertyName).orElse(this.getWorkflowAggregateIdPropertyName(workflowAggregateClass.getSuperclass())));
    }

    private String propertyName(Method method) {
        if (method.getName().startsWith("get")) {
            if (method.getName().length() < 4) {
                return method.getName();
            }
            return method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        }
        if (method.getName().startsWith("is")) {
            if (method.getName().length() < 3) {
                return method.getName();
            }
            return method.getName().substring(2, 3).toLowerCase() + method.getName().substring(3);
        }
        return method.getName();
    }

    private List<String> getVariablesToFetch(String idPropertyName, List<MethodParameter> parameters) {
        LinkedList<String> result = new LinkedList<String>();
        result.add(idPropertyName);
        parameters.stream().filter(parameter -> parameter instanceof ParameterVariables).flatMap(parameter -> ((ParameterVariables)parameter).getVariables().stream()).forEach(result::add);
        return result;
    }

    public void wireTask(String workflowModuleId, Camunda8ProcessService<?> processService, Camunda8Connectable connectable) {
        super.wireTask((Connectable)connectable, false, (method, annotation) -> this.methodMatchesTaskDefinition(connectable, (Method)method, (WorkflowTask)annotation), (method, annotation) -> this.methodMatchesElementId(connectable, (Method)method, (Annotation)annotation), (method, annotation) -> this.validateParameters(processService, (Method)method), (bean, method, parameters) -> this.connectToBpms(workflowModuleId, processService, bean, connectable, method, (List<MethodParameter>)parameters));
    }
}

