/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment.jpa;

import io.vanillabp.camunda8.deployment.jpa.DeployedBpmn;
import io.vanillabp.camunda8.deployment.jpa.DeployedProcess;
import io.vanillabp.camunda8.deployment.jpa.Deployment;
import io.vanillabp.camunda8.deployment.jpa.DeploymentResource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;

@Configuration
@AutoConfigureBefore(value={HibernateJpaAutoConfiguration.class})
public class JpaDeploymentEntityConfiguration {
    @Bean
    public BeanPostProcessor camunda8JpaBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (!(bean instanceof LocalContainerEntityManagerFactoryBean)) {
                    return bean;
                }
                ((LocalContainerEntityManagerFactoryBean)bean).setPersistenceUnitPostProcessors(new PersistenceUnitPostProcessor[]{JpaDeploymentEntityConfiguration.this.c8JpaPersistenceUnitPostProcessor()});
                return bean;
            }
        };
    }

    public PersistenceUnitPostProcessor c8JpaPersistenceUnitPostProcessor() {
        return pui -> {
            pui.addManagedClassName(DeploymentResource.class.getName());
            pui.addManagedClassName(DeployedBpmn.class.getName());
            pui.addManagedClassName(Deployment.class.getName());
            pui.addManagedClassName(DeployedProcess.class.getName());
        };
    }
}

