/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment.jpa;

import io.vanillabp.camunda8.deployment.DeploymentPersistence;
import io.vanillabp.camunda8.deployment.jpa.DeployedBpmnRepository;
import io.vanillabp.camunda8.deployment.jpa.DeploymentRepository;
import io.vanillabp.camunda8.deployment.jpa.DeploymentResourceRepository;
import io.vanillabp.camunda8.deployment.jpa.JpaDeploymentPersistence;
import io.vanillabp.springboot.utils.JpaSpringDataUtilConfiguration;
import jakarta.persistence.EntityManager;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;

@Configuration
@AutoConfigureAfter(value={JpaSpringDataUtilConfiguration.class, JpaRepositoriesAutoConfiguration.class})
@ConditionalOnBean(name={"jpaSpringDataUtil"})
public class JpaDeploymentPersistenceConfiguration {
    @Bean(value={"Camunda8DeployedBpmnRepository"})
    @ConditionalOnMissingBean(value={DeployedBpmnRepository.class})
    public DeployedBpmnRepository camunda8JpaDeployedBpmnRepositoryRepository(EntityManager entityManager) {
        JpaRepositoryFactory jpaRepositoryFactory = new JpaRepositoryFactory(entityManager);
        return (DeployedBpmnRepository)jpaRepositoryFactory.getRepository(DeployedBpmnRepository.class);
    }

    @Bean(value={"Camunda8DeploymentResourceRepository"})
    @ConditionalOnMissingBean(value={DeploymentResourceRepository.class})
    public DeploymentResourceRepository camunda8JpaDeploymentResourceRepository(EntityManager entityManager) {
        JpaRepositoryFactory jpaRepositoryFactory = new JpaRepositoryFactory(entityManager);
        return (DeploymentResourceRepository)jpaRepositoryFactory.getRepository(DeploymentResourceRepository.class);
    }

    @Bean(value={"Camunda8DeploymentRepository"})
    @ConditionalOnMissingBean(value={DeploymentRepository.class})
    public DeploymentRepository camunda8JpaDeploymentRepository(EntityManager entityManager) {
        JpaRepositoryFactory jpaRepositoryFactory = new JpaRepositoryFactory(entityManager);
        return (DeploymentRepository)jpaRepositoryFactory.getRepository(DeploymentRepository.class);
    }

    @Bean
    public DeploymentPersistence camunda8DeploymentPersistence(DeploymentResourceRepository deploymentResourceRepository, DeploymentRepository deploymentRepository, DeployedBpmnRepository deployedBpmnRepository) {
        return new JpaDeploymentPersistence(deploymentResourceRepository, deploymentRepository, deployedBpmnRepository);
    }
}

