/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment.mongodb;

import io.vanillabp.camunda8.deployment.DeploymentPersistence;
import io.vanillabp.camunda8.deployment.mongodb.DeployedBpmnRepository;
import io.vanillabp.camunda8.deployment.mongodb.DeploymentRepository;
import io.vanillabp.camunda8.deployment.mongodb.DeploymentResourceRepository;
import io.vanillabp.camunda8.deployment.mongodb.MongoDbDeploymentPersistence;
import io.vanillabp.springboot.utils.MongoDbSpringDataUtil;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoRepositoriesAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;

@Configuration
@AutoConfigureAfter(value={MongoRepositoriesAutoConfiguration.class})
@ConditionalOnBean(value={MongoDbSpringDataUtil.class})
public class MongoDbDeploymentPersistenceConfiguration {
    private MongoRepositoryFactory mongoRepositoryFactory;

    @Bean
    @ConditionalOnMissingBean(value={DeployedBpmnRepository.class})
    public DeployedBpmnRepository camunda8MongoDbDeployedBpmnRepository(MongoOperations mongoOperations) {
        if (this.mongoRepositoryFactory == null) {
            this.mongoRepositoryFactory = new MongoRepositoryFactory(mongoOperations);
        }
        return (DeployedBpmnRepository)this.mongoRepositoryFactory.getRepository(DeployedBpmnRepository.class);
    }

    @Bean
    @ConditionalOnMissingBean(value={DeploymentResourceRepository.class})
    public DeploymentResourceRepository camunda8MongoDbDeploymentResourceRepository(MongoOperations mongoOperations) {
        if (this.mongoRepositoryFactory == null) {
            this.mongoRepositoryFactory = new MongoRepositoryFactory(mongoOperations);
        }
        return (DeploymentResourceRepository)this.mongoRepositoryFactory.getRepository(DeploymentResourceRepository.class);
    }

    @Bean
    @ConditionalOnMissingBean(value={DeploymentRepository.class})
    public DeploymentRepository c8MongoDbDeploymentRepository(MongoOperations mongoOperations) {
        if (this.mongoRepositoryFactory == null) {
            this.mongoRepositoryFactory = new MongoRepositoryFactory(mongoOperations);
        }
        return (DeploymentRepository)this.mongoRepositoryFactory.getRepository(DeploymentRepository.class);
    }

    @Bean
    public DeploymentPersistence c8DeploymentPersistence(DeploymentResourceRepository deploymentResourceRepository, DeploymentRepository deploymentRepository, DeployedBpmnRepository deployedBpmnRepository) {
        return new MongoDbDeploymentPersistence(deploymentResourceRepository, deploymentRepository, deployedBpmnRepository);
    }
}

