/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8;

import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import java.time.Duration;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="vanillabp", ignoreUnknownFields=true)
public class Camunda8VanillaBpProperties {
    private Map<String, WorkflowModuleAdapterProperties> workflowModules = Map.of();
    private static final WorkflowModuleAdapterProperties defaultProperties = new WorkflowModuleAdapterProperties();
    private static final WorkflowModuleAdapterConfiguration defaultAdapterProperties = new WorkflowModuleAdapterConfiguration();

    public Map<String, WorkflowModuleAdapterProperties> getWorkflowModules() {
        return this.workflowModules;
    }

    public void setWorkflowModules(Map<String, WorkflowModuleAdapterProperties> workflowModules) {
        this.workflowModules = workflowModules;
        workflowModules.forEach((workflowModuleId, properties) -> {
            properties.workflowModuleId = workflowModuleId;
        });
    }

    public String getTenantId(String workflowModuleId) {
        WorkflowModuleAdapterConfiguration configuration = this.workflowModules.getOrDefault(workflowModuleId, defaultProperties).getAdapters().getOrDefault("camunda8", defaultAdapterProperties);
        if (!configuration.isUseTenants()) {
            return null;
        }
        if (StringUtils.hasText((String)configuration.getTenantId())) {
            return configuration.getTenantId();
        }
        return workflowModuleId;
    }

    public boolean isTaskIdAsHexString(String workflowModuleId) {
        WorkflowModuleAdapterConfiguration configuration = this.workflowModules.getOrDefault(workflowModuleId, defaultProperties).getAdapters().getOrDefault("camunda8", defaultAdapterProperties);
        return configuration.isTaskIdAsHexString();
    }

    public WorkerProperties getUserTaskWorkerProperties(String workflowModuleId) {
        return this.getWorkerProperties(workflowModuleId, null, null);
    }

    public WorkerProperties getWorkerProperties(String workflowModuleId, String bpmnProcessId, String taskDefinition) {
        WorkerProperties result = new WorkerProperties();
        WorkflowModuleAdapterProperties workflowModule = this.workflowModules.get(workflowModuleId);
        if (workflowModule == null) {
            return result;
        }
        WorkflowModuleAdapterConfiguration workflowModuleAdapter = workflowModule.getAdapters().get("camunda8");
        if (workflowModuleAdapter != null) {
            result.apply(workflowModuleAdapter);
        }
        if (bpmnProcessId == null) {
            return result;
        }
        WorkflowAdapterProperties workflow = workflowModule.getWorkflows().get(bpmnProcessId);
        if (workflow == null) {
            return result;
        }
        WorkerProperties workflowAdapter = workflow.getAdapters().get("camunda8");
        if (workflowAdapter != null) {
            result.apply(workflowAdapter);
        }
        if (taskDefinition == null) {
            return result;
        }
        TaskProperties task = workflow.getTasks().get(taskDefinition);
        if (task == null) {
            return result;
        }
        WorkerProperties taskAdapter = task.getAdapters().get("camunda8");
        if (taskAdapter != null) {
            result.apply(taskAdapter);
        }
        return result;
    }

    public static class WorkflowModuleAdapterProperties {
        String workflowModuleId;
        private Map<String, WorkflowModuleAdapterConfiguration> adapters = Map.of();
        private Map<String, WorkflowAdapterProperties> workflows = Map.of();

        public Map<String, WorkflowModuleAdapterConfiguration> getAdapters() {
            return this.adapters;
        }

        public void setAdapters(Map<String, WorkflowModuleAdapterConfiguration> adapters) {
            this.adapters = adapters;
        }

        public Map<String, WorkflowAdapterProperties> getWorkflows() {
            return this.workflows;
        }

        public void setWorkflows(Map<String, WorkflowAdapterProperties> workflows) {
            this.workflows = workflows;
            workflows.forEach((bpmnProcessId, properties) -> {
                properties.bpmnProcessId = bpmnProcessId;
                properties.workflowModule = this;
            });
        }
    }

    public static class WorkflowModuleAdapterConfiguration
    extends AdapterConfiguration {
        private boolean taskIdAsHexString = false;

        public boolean isTaskIdAsHexString() {
            return this.taskIdAsHexString;
        }

        public void setTaskIdAsHexString(boolean taskIdAsHexString) {
            this.taskIdAsHexString = taskIdAsHexString;
        }
    }

    public static class WorkerProperties {
        private Duration taskTimeout = null;
        private Duration pollInterval = null;
        private Duration pollRequestTimeout = null;
        private Boolean streamEnabled = null;
        private Duration streamTimeout = null;

        public void apply(WorkerProperties original) {
            if (original.taskTimeout != null) {
                this.taskTimeout = original.taskTimeout;
            }
            if (original.pollInterval != null) {
                this.pollInterval = original.pollInterval;
            }
            if (original.pollRequestTimeout != null) {
                this.pollRequestTimeout = original.pollRequestTimeout;
            }
            if (original.isStreamEnabled() != null) {
                this.streamEnabled = original.isStreamEnabled();
            }
            if (original.streamTimeout != null) {
                this.streamTimeout = original.streamTimeout;
            }
        }

        public void applyToWorker(JobWorkerBuilderStep1.JobWorkerBuilderStep3 workerBuilder) {
            if (this.taskTimeout != null) {
                workerBuilder.timeout(this.taskTimeout);
            }
            this.applyToUserTaskWorker(workerBuilder);
        }

        public void applyToUserTaskWorker(JobWorkerBuilderStep1.JobWorkerBuilderStep3 workerBuilder) {
            if (this.pollInterval != null) {
                workerBuilder.pollInterval(this.pollInterval);
            }
            if (this.pollRequestTimeout != null) {
                workerBuilder.requestTimeout(this.pollRequestTimeout);
            }
            if (this.streamEnabled != null) {
                workerBuilder.streamEnabled(this.streamEnabled.booleanValue());
            }
            if (this.streamTimeout != null) {
                workerBuilder.streamTimeout(this.streamTimeout);
            }
        }

        public Duration getTaskTimeout() {
            return this.taskTimeout;
        }

        public Duration getPollInterval() {
            return this.pollInterval;
        }

        public Duration getPollRequestTimeout() {
            return this.pollRequestTimeout;
        }

        public Boolean isStreamEnabled() {
            return this.streamEnabled;
        }

        public Duration getStreamTimeout() {
            return this.streamTimeout;
        }

        public void setTaskTimeout(Duration taskTimeout) {
            this.taskTimeout = taskTimeout;
        }

        public void setPollInterval(Duration pollInterval) {
            this.pollInterval = pollInterval;
        }

        public void setPollRequestTimeout(Duration pollRequestTimeout) {
            this.pollRequestTimeout = pollRequestTimeout;
        }

        public void setStreamEnabled(boolean streamEnabled) {
            this.streamEnabled = streamEnabled;
        }

        public void setStreamTimeout(Duration streamTimeout) {
            this.streamTimeout = streamTimeout;
        }
    }

    public static class WorkflowAdapterProperties {
        String bpmnProcessId;
        WorkflowModuleAdapterProperties workflowModule;
        private Map<String, WorkerProperties> adapters = Map.of();
        private Map<String, TaskProperties> tasks = Map.of();

        public WorkflowModuleAdapterProperties getWorkflowModule() {
            return this.workflowModule;
        }

        public String getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        public Map<String, WorkerProperties> getAdapters() {
            return this.adapters;
        }

        public void setAdapters(Map<String, WorkerProperties> adapters) {
            this.adapters = adapters;
        }

        public Map<String, TaskProperties> getTasks() {
            return this.tasks;
        }

        public void setTasks(Map<String, TaskProperties> tasks) {
            this.tasks = tasks;
        }
    }

    public static class TaskProperties {
        private Map<String, WorkerProperties> adapters = Map.of();

        public Map<String, WorkerProperties> getAdapters() {
            return this.adapters;
        }

        public void setAdapters(Map<String, WorkerProperties> adapters) {
            this.adapters = adapters;
        }
    }

    public static class AdapterConfiguration
    extends WorkerProperties {
        private boolean useTenants = true;
        private String tenantId;

        public boolean isUseTenants() {
            return this.useTenants;
        }

        public void setUseTenants(boolean useTenants) {
            this.useTenants = useTenants;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }
    }
}

