/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment.mongodb;

import io.vanillabp.camunda8.deployment.Deployment;
import io.vanillabp.camunda8.deployment.DeploymentPersistence;
import io.vanillabp.camunda8.deployment.mongodb.DeployedBpmn;
import io.vanillabp.camunda8.deployment.mongodb.DeployedBpmnRepository;
import io.vanillabp.camunda8.deployment.mongodb.DeployedProcess;
import io.vanillabp.camunda8.deployment.mongodb.DeploymentRepository;
import io.vanillabp.camunda8.deployment.mongodb.DeploymentResource;
import io.vanillabp.camunda8.deployment.mongodb.DeploymentResourceRepository;
import java.time.OffsetDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class MongoDbDeploymentPersistence
implements DeploymentPersistence {
    private final DeploymentResourceRepository deploymentResourceRepository;
    private final DeploymentRepository deploymentRepository;
    private final DeployedBpmnRepository deployedBpmnRepository;

    public MongoDbDeploymentPersistence(DeploymentResourceRepository deploymentResourceRepository, DeploymentRepository deploymentRepository, DeployedBpmnRepository deployedBpmnRepository) {
        this.deploymentResourceRepository = deploymentResourceRepository;
        this.deploymentRepository = deploymentRepository;
        this.deployedBpmnRepository = deployedBpmnRepository;
    }

    @Override
    public Optional<? extends Deployment> findDeployedProcess(long definitionKey) {
        return this.deploymentRepository.findByDefinitionKey(definitionKey);
    }

    @Override
    public <R extends io.vanillabp.camunda8.deployment.DeployedProcess> R addDeployedProcess(long definitionKey, int version, int packageId, String bpmnProcessId, io.vanillabp.camunda8.deployment.DeployedBpmn bpmn, OffsetDateTime publishedAt) {
        DeployedProcess deployedProcess = new DeployedProcess();
        DeployedBpmn bpmnEntity = bpmn instanceof DeployedBpmn ? (DeployedBpmn)bpmn : (DeploymentResource)this.deploymentResourceRepository.findById(bpmn.getFileId()).orElseThrow(() -> new RuntimeException("Unknown BPMN file ID: " + bpmn.getFileId()));
        deployedProcess.setDefinitionKey(definitionKey);
        deployedProcess.setVersion(version);
        deployedProcess.setPackageId(packageId);
        deployedProcess.setBpmnProcessId(bpmnProcessId);
        deployedProcess.setDeployedResource(bpmnEntity);
        deployedProcess.setPublishedAt(OffsetDateTime.now());
        List deployments = Optional.ofNullable(bpmnEntity.getDeployments()).orElse(new LinkedList());
        deployments.add(deployedProcess);
        this.deploymentResourceRepository.save(bpmnEntity);
        return (R)((io.vanillabp.camunda8.deployment.DeployedProcess)this.deploymentRepository.save(deployedProcess));
    }

    @Override
    public Optional<? extends io.vanillabp.camunda8.deployment.DeploymentResource> findDeploymentResource(int fileId) {
        return this.deploymentResourceRepository.findById(fileId);
    }

    @Override
    public <R extends io.vanillabp.camunda8.deployment.DeployedBpmn> R addDeployedBpmn(int fileId, String resourceName, byte[] resource) {
        DeployedBpmn bpmn = new DeployedBpmn();
        bpmn.setFileId(fileId);
        bpmn.setResource(resource);
        bpmn.setResourceName(resourceName);
        return (R)((io.vanillabp.camunda8.deployment.DeployedBpmn)this.deploymentResourceRepository.save(bpmn));
    }

    @Override
    public List<? extends io.vanillabp.camunda8.deployment.DeployedBpmn> getBpmnNotOfPackage(int packageId) {
        return this.deployedBpmnRepository.findAll().stream().filter(deployedBpmn -> deployedBpmn.getDeployments().stream().anyMatch(deployment -> deployment.getPackageId() != packageId)).distinct().toList();
    }
}

