/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.service;

import io.camunda.zeebe.client.api.command.ClientStatusException;
import io.grpc.Status;
import io.vanillabp.camunda8.service.Camunda8TransactionAspect;
import io.vanillabp.spi.service.TaskException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

public class Camunda8TransactionProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8TransactionProcessor.class);

    public static void registerCallbacks(Supplier<Map.Entry<Runnable, Supplier<String>>> testForTaskAlreadyCompletedOrCancelledCommand, Map.Entry<Consumer<TaskException>, Function<TaskException, String>> bpmnErrorCommand, Map.Entry<Consumer<Exception>, Function<Exception, String>> handlerFailedCommand, Supplier<Map.Entry<Runnable, Supplier<String>>> handlerCompletedCommand) {
        Camunda8TransactionAspect.TaskHandlerActions actions = Camunda8TransactionAspect.actions.get();
        actions.testForTaskAlreadyCompletedOrCancelledCommand = testForTaskAlreadyCompletedOrCancelledCommand;
        actions.bpmnErrorCommand = bpmnErrorCommand;
        actions.handlerFailedCommand = handlerFailedCommand;
        actions.handlerCompletedCommand = handlerCompletedCommand;
    }

    public static Map.Entry<Consumer<TaskException>, Function<TaskException, String>> bpmnErrorCommandCallback() {
        return Camunda8TransactionAspect.actions.get().bpmnErrorCommand;
    }

    public static Map.Entry<Consumer<Exception>, Function<Exception, String>> handlerFailedCommandCallback() {
        return Camunda8TransactionAspect.actions.get().handlerFailedCommand;
    }

    public static Map.Entry<Runnable, Supplier<String>> handlerCompletedCommandCallback() {
        return Camunda8TransactionAspect.actions.get().handlerCompletedCommand.get();
    }

    public static void unregisterCallbacks() {
        Camunda8TransactionAspect.clearCallbacks();
    }

    @TransactionalEventListener(phase=TransactionPhase.BEFORE_COMMIT, fallbackExecution=true)
    public void processPreCommit(Camunda8TestForTaskAlreadyCompletedOrCancelled event) {
        try {
            logger.trace("Will test for existence of task '{}' initiated by: {}", (Object)event.description.get(), event.getSource());
            event.runnable.run();
        }
        catch (Exception e) {
            ClientStatusException clientStatusException;
            if (e instanceof ClientStatusException && (clientStatusException = (ClientStatusException)e).getStatus().getCode() == Status.NOT_FOUND.getCode()) {
                throw new RuntimeException("Will rollback '" + String.valueOf(event.getSource()) + "' because job was already completed/cancelled! Test-command giving status 'NOT_FOUND':\n" + event.description.get());
            }
            throw new RuntimeException("Will rollback because testing for job due to '" + String.valueOf(event.getSource()) + "'! Test-command:\n" + event.description.get(), e);
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, fallbackExecution=true)
    public void processPostCommit(Camunda8CommandAfterTx event) {
        try {
            logger.trace("Will execute Camunda command for '{}' initiated by: {}", (Object)event.description.get(), event.getSource());
            event.runnable.run();
        }
        catch (Exception e) {
            logger.error("Could not execute camunda command for '{}' initiated by: {}! Manual action required!", new Object[]{event.description.get(), event.getSource(), e});
        }
    }

    public static class Camunda8TestForTaskAlreadyCompletedOrCancelled
    extends ApplicationEvent {
        final Supplier<String> description;
        final Runnable runnable;

        public Camunda8TestForTaskAlreadyCompletedOrCancelled(Object source, Runnable runnable, Supplier<String> description) {
            super(source);
            this.runnable = runnable;
            this.description = description;
        }
    }

    public static class Camunda8CommandAfterTx
    extends ApplicationEvent {
        final Supplier<String> description;
        final Runnable runnable;

        public Camunda8CommandAfterTx(Object source, Runnable runnable, Supplier<String> description) {
            super(source);
            this.runnable = runnable;
            this.description = description;
        }
    }
}

