/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.wiring;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.ThrowErrorCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.vanillabp.camunda8.LoggingContext;
import io.vanillabp.camunda8.service.Camunda8TransactionAspect;
import io.vanillabp.camunda8.service.Camunda8TransactionProcessor;
import io.vanillabp.camunda8.wiring.Camunda8Connectable;
import io.vanillabp.spi.service.MultiInstanceElementResolver;
import io.vanillabp.spi.service.TaskEvent;
import io.vanillabp.spi.service.TaskException;
import io.vanillabp.springboot.adapter.MultiInstance;
import io.vanillabp.springboot.adapter.TaskHandlerBase;
import io.vanillabp.springboot.adapter.wiring.WorkflowAggregateCache;
import io.vanillabp.springboot.parameters.MethodParameter;
import io.vanillabp.springboot.parameters.ResolverBasedMultiInstanceMethodParameter;
import io.vanillabp.springboot.parameters.WorkflowAggregateMethodParameter;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;

public class Camunda8TaskHandler
extends TaskHandlerBase
implements JobHandler,
Consumer<ZeebeClient> {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8TaskHandler.class);
    private final Camunda8Connectable.Type taskType;
    private final String idPropertyName;
    private final String tenantId;
    private final String workflowModuleId;
    private final String bpmnProcessId;
    private final boolean publishUserTaskIdAsHexString;
    private ZeebeClient zeebeClient;

    public Camunda8TaskHandler(Camunda8Connectable.Type taskType, CrudRepository<Object, Object> workflowAggregateRepository, Object bean, Method method, List<MethodParameter> parameters, String idPropertyName, String tenantId, String workflowModuleId, String bpmnProcessId, boolean publishUserTaskIdAsHexString) {
        super(workflowAggregateRepository, bean, method, parameters);
        this.taskType = taskType;
        this.idPropertyName = idPropertyName;
        this.tenantId = tenantId;
        this.workflowModuleId = workflowModuleId;
        this.bpmnProcessId = bpmnProcessId;
        this.publishUserTaskIdAsHexString = publishUserTaskIdAsHexString;
    }

    @Override
    public void accept(ZeebeClient zeebeClient) {
        this.zeebeClient = zeebeClient;
    }

    protected Logger getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(JobClient client, ActivatedJob job) throws Exception {
        try {
            Object businessKey = this.getVariable(job, this.idPropertyName);
            String taskId = this.publishUserTaskIdAsHexString ? Long.toHexString(job.getKey()) : Long.toString(job.getKey());
            LoggingContext.setLoggingContext("camunda8", this.tenantId, this.workflowModuleId, businessKey == null ? null : businessKey.toString(), this.bpmnProcessId, taskId, Long.toString(job.getProcessInstanceKey()), job.getBpmnProcessId() + "#" + job.getElementId(), Long.toString(job.getElementInstanceKey()));
            logger.trace("Will handle task '{}' (task-definition '{}\u2018) of workflow '{}' (instance-id '{}') as job '{}'", new Object[]{job.getElementId(), job.getType(), job.getBpmnProcessId(), job.getProcessInstanceKey(), job.getKey()});
            AtomicBoolean taskIdRetrieved = new AtomicBoolean(false);
            WorkflowAggregateCache workflowAggregateCache = new WorkflowAggregateCache();
            Camunda8TransactionAspect.registerDeferredInTransaction(new Camunda8TransactionAspect.RunDeferredInTransactionSupplier[this.parameters.size()], this.saveAggregateAfterWorkflowTask(workflowAggregateCache));
            Camunda8TransactionProcessor.registerCallbacks(() -> {
                if (this.taskType == Camunda8Connectable.Type.USERTASK) {
                    return null;
                }
                if (taskIdRetrieved.get()) {
                    return null;
                }
                return this.testForTaskWasCompletedOrCancelled(job);
            }, this.doThrowError(client, job, workflowAggregateCache), this.doFailed(client, job), () -> {
                if (this.taskType == Camunda8Connectable.Type.USERTASK) {
                    return null;
                }
                if (taskIdRetrieved.get()) {
                    return null;
                }
                return this.doComplete(client, job, workflowAggregateCache);
            });
            Function<String, Object> multiInstanceSupplier = multiInstanceVariable -> this.getVariable(job, (String)multiInstanceVariable);
            super.execute(workflowAggregateCache, businessKey, false, new BiFunction[]{(args, param) -> this.processTaskParameter((Object[])args, (MethodParameter)param, taskParameter -> this.getVariable(job, (String)taskParameter)), (args, param) -> this.processTaskIdParameter((Object[])args, (MethodParameter)param, () -> {
                taskIdRetrieved.set(true);
                return taskId;
            }), (args, param) -> this.processTaskEventParameter((Object[])args, (MethodParameter)param, () -> TaskEvent.Event.CREATED), (args, param) -> this.processMultiInstanceIndexParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceTotalParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceElementParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceResolverParameter((Object[])args, (MethodParameter)param, () -> {
                if (workflowAggregateCache.workflowAggregate == null) {
                    workflowAggregateCache.workflowAggregate = this.workflowAggregateRepository.findById(businessKey).orElseThrow();
                }
                return workflowAggregateCache.workflowAggregate;
            }, multiInstanceSupplier)});
        }
        finally {
            Camunda8TransactionProcessor.unregisterCallbacks();
            Camunda8TransactionAspect.unregisterDeferredInTransaction();
            LoggingContext.clearContext();
        }
    }

    protected Object getMultiInstanceElement(String name, Function<String, Object> multiInstanceSupplier) {
        return multiInstanceSupplier.apply(name);
    }

    protected Integer getMultiInstanceIndex(String name, Function<String, Object> multiInstanceSupplier) {
        return (Integer)multiInstanceSupplier.apply(name + "_index") - 1;
    }

    protected Integer getMultiInstanceTotal(String name, Function<String, Object> multiInstanceSupplier) {
        return (Integer)multiInstanceSupplier.apply(name + "_total");
    }

    protected MultiInstance<Object> getMultiInstance(String name, Function<String, Object> multiInstanceSupplier) {
        return new MultiInstance(this.getMultiInstanceElement(name, multiInstanceSupplier), this.getMultiInstanceTotal(name, multiInstanceSupplier).intValue(), this.getMultiInstanceIndex(name, multiInstanceSupplier).intValue());
    }

    private Object getVariable(ActivatedJob job, String name) {
        return job.getVariablesAsMap().get(name);
    }

    public Runnable saveAggregateAfterWorkflowTask(WorkflowAggregateCache aggregateCache) {
        return () -> {
            if (aggregateCache.workflowAggregate != null) {
                this.workflowAggregateRepository.save(aggregateCache.workflowAggregate);
            }
        };
    }

    public Map.Entry<Runnable, Supplier<String>> testForTaskWasCompletedOrCancelled(ActivatedJob job) {
        return Map.entry(() -> this.zeebeClient.newUpdateTimeoutCommand(job).timeout(Duration.ofMinutes(10L)).send().join(5L, TimeUnit.MINUTES), () -> "update timeout (BPMN: " + job.getBpmnProcessId() + "; Element: " + job.getElementId() + "; Task-Definition: " + job.getType() + "; Process-Instance: " + job.getProcessInstanceKey() + "; Job: " + job.getKey() + ")");
    }

    public Map.Entry<Runnable, Supplier<String>> doComplete(JobClient jobClient, ActivatedJob job, WorkflowAggregateCache workflowAggregateCache) {
        return Map.entry(() -> {
            CompleteJobCommandStep1 completeCommand = jobClient.newCompleteCommand(job.getKey());
            if (workflowAggregateCache.workflowAggregate != null) {
                completeCommand = completeCommand.variables(workflowAggregateCache.workflowAggregate);
            }
            completeCommand.send().exceptionally(t -> {
                throw new RuntimeException("error", (Throwable)t);
            });
        }, () -> "complete command (BPMN: " + job.getBpmnProcessId() + "; Element: " + job.getElementId() + "; Task-Definition: " + job.getType() + "; Process-Instance: " + job.getProcessInstanceKey() + "; Job: " + job.getKey() + ")");
    }

    private Map.Entry<Consumer<TaskException>, Function<TaskException, String>> doThrowError(JobClient jobClient, ActivatedJob job, WorkflowAggregateCache workflowAggregateCache) {
        return Map.entry(taskException -> {
            ThrowErrorCommandStep1.ThrowErrorCommandStep2 throwErrorCommand = jobClient.newThrowErrorCommand(job.getKey()).errorCode(taskException.getErrorCode()).errorMessage(taskException.getErrorName());
            if (workflowAggregateCache.workflowAggregate != null) {
                throwErrorCommand = throwErrorCommand.variables(workflowAggregateCache.workflowAggregate);
            }
            throwErrorCommand.send().exceptionally(t -> {
                throw new RuntimeException("error", (Throwable)t);
            });
        }, taskException -> "throw error command (BPMN: " + job.getBpmnProcessId() + "; Element: " + job.getElementId() + "; Task-Definition: " + job.getType() + "; Process-Instance: " + job.getProcessInstanceKey() + "; Job: " + job.getKey() + ")");
    }

    private Map.Entry<Consumer<Exception>, Function<Exception, String>> doFailed(JobClient jobClient, ActivatedJob job) {
        return Map.entry(exception -> jobClient.newFailCommand(job).retries(0).errorMessage(exception.getMessage()).send().exceptionally(t -> {
            throw new RuntimeException("error", (Throwable)t);
        }), taskException -> "fail command (BPMN: " + job.getBpmnProcessId() + "; Element: " + job.getElementId() + "; Task-Definition: " + job.getType() + "; Process-Instance: " + job.getProcessInstanceKey() + "; Job: " + job.getKey() + ")");
    }

    protected boolean processWorkflowAggregateParameter(Object[] args, MethodParameter param, WorkflowAggregateCache workflowAggregateCache, Object workflowAggregateId) {
        if (!(param instanceof WorkflowAggregateMethodParameter)) {
            return true;
        }
        Camunda8TransactionAspect.runDeferredInTransaction.get().argsSupplier[param.getIndex()] = () -> {
            workflowAggregateCache.workflowAggregate = this.workflowAggregateRepository.findById(workflowAggregateId).orElse(null);
            return workflowAggregateCache.workflowAggregate;
        };
        args[param.getIndex()] = null;
        return false;
    }

    protected boolean processMultiInstanceResolverParameter(Object[] args, MethodParameter param, Supplier<Object> workflowAggregate, Function<String, Object> multiInstanceSupplier) {
        if (!(param instanceof ResolverBasedMultiInstanceMethodParameter)) {
            return true;
        }
        MultiInstanceElementResolver resolver = ((ResolverBasedMultiInstanceMethodParameter)param).getResolverBean();
        HashMap multiInstances = new HashMap();
        resolver.getNames().forEach(name -> multiInstances.put(name, this.getMultiInstance((String)name, multiInstanceSupplier)));
        Camunda8TransactionAspect.runDeferredInTransaction.get().argsSupplier[param.getIndex()] = () -> {
            try {
                return resolver.resolve(workflowAggregate.get(), (Map)multiInstances);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed processing MultiInstanceElementResolver for parameter '" + param.getParameter() + "' of method '" + String.valueOf(this.method) + "'", e);
            }
        };
        args[param.getIndex()] = null;
        return false;
    }
}

