/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.wiring;

import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.vanillabp.camunda8.wiring.Camunda8TaskHandler;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Camunda8UserTaskHandler
implements JobHandler {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8UserTaskHandler.class);
    private static final int MAX_ATTEMPTS_OF_ASSIGNING_USERTASKS = 1000;
    private static final String DEFAULT_TENANT_ID = "<default>";
    private final Map<String, Camunda8TaskHandler> taskHandlers = new HashMap<String, Camunda8TaskHandler>();
    private final String workerId;

    public Camunda8UserTaskHandler(String workerId) {
        this.workerId = workerId;
    }

    private String internalKey(String tenantId, String bpmnProcessId, String elementId) {
        String tenantIdKey = DEFAULT_TENANT_ID.equals(tenantId) ? null : tenantId;
        return tenantIdKey + "#" + bpmnProcessId + "#" + elementId;
    }

    public void addTaskHandler(String tenantId, String bpmnProcessId, String elementId, Camunda8TaskHandler taskHandler) {
        String key = this.internalKey(tenantId, bpmnProcessId, elementId);
        this.taskHandlers.put(key, taskHandler);
    }

    public void handle(JobClient client, ActivatedJob job) throws Exception {
        String key = this.internalKey(job.getTenantId(), job.getBpmnProcessId(), job.getElementId());
        Camunda8TaskHandler taskHandler = this.taskHandlers.get(key);
        if (taskHandler == null) {
            if (job.getRetries() < 1000) {
                logger.trace("No handler for BPMN process ID '{}' and element ID '{}' found! Will reject user-task to be handled by another workflow module (retry: {}/{}).", new Object[]{job.getBpmnProcessId(), job.getElementId(), job.getRetries(), 1000});
                client.newFailCommand(job).retries(job.getRetries() + 1).errorMessage("Worker '" + this.workerId + "' is not aware of BPMN process ID '" + job.getBpmnProcessId() + "' and user-task '" + job.getElementId() + "'!").retryBackoff(Duration.ofMillis(1L)).send();
            } else {
                client.newFailCommand(job).retries(0).errorMessage("No worker is aware of BPMN process ID '" + job.getBpmnProcessId() + "' and user-task '" + job.getElementId() + "'!").send();
                logger.error("No handler for BPMN process ID '{}' and element ID '{}' found even after {} retries! An incident is created.", new Object[]{job.getBpmnProcessId(), job.getElementId(), 1000});
            }
            return;
        }
        taskHandler.handle(client, job);
    }
}

