/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8;

import io.vanillabp.camunda8.Camunda8VanillaBpProperties;
import io.vanillabp.camunda8.deployment.Camunda8DeploymentAdapter;
import io.vanillabp.camunda8.deployment.DeploymentPersistence;
import io.vanillabp.camunda8.deployment.DeploymentService;
import io.vanillabp.camunda8.service.Camunda8ProcessService;
import io.vanillabp.camunda8.service.Camunda8TransactionAspect;
import io.vanillabp.camunda8.service.Camunda8TransactionProcessor;
import io.vanillabp.camunda8.wiring.Camunda8Connectable;
import io.vanillabp.camunda8.wiring.Camunda8TaskHandler;
import io.vanillabp.camunda8.wiring.Camunda8TaskWiring;
import io.vanillabp.camunda8.wiring.Camunda8UserTaskHandler;
import io.vanillabp.springboot.adapter.AdapterConfigurationBase;
import io.vanillabp.springboot.adapter.SpringBeanUtil;
import io.vanillabp.springboot.adapter.SpringDataUtil;
import io.vanillabp.springboot.adapter.VanillaBpProperties;
import io.vanillabp.springboot.parameters.MethodParameter;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.data.repository.CrudRepository;
import org.springframework.retry.annotation.EnableRetry;

@AutoConfigurationPackage(basePackageClasses={Camunda8AdapterConfiguration.class})
@AutoConfigureBefore(name={"io.camunda.zeebe.spring.client.CamundaAutoConfiguration", "io.camunda.zeebe.spring.client.configuration.CamundaAutoConfiguration"})
@EnableConfigurationProperties(value={Camunda8VanillaBpProperties.class})
@EnableRetry
public class Camunda8AdapterConfiguration
extends AdapterConfigurationBase<Camunda8ProcessService<?>> {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8AdapterConfiguration.class);
    public static final String ADAPTER_ID = "camunda8";
    @Value(value="${workerId}")
    private String workerId;
    @Value(value="${spring.application.name:@null}")
    private String applicationName;
    @Autowired
    private SpringDataUtil springDataUtil;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private Camunda8VanillaBpProperties camunda8Properties;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    @PostConstruct
    public void init() {
        logger.debug("Will use SpringDataUtil class '{}'", (Object)AopProxyUtils.ultimateTargetClass((Object)this.springDataUtil));
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public Camunda8TransactionAspect camunda8TransactionAspect() {
        return new Camunda8TransactionAspect(this.eventPublisher);
    }

    public String getAdapterId() {
        return ADAPTER_ID;
    }

    @Bean
    public Camunda8DeploymentAdapter camunda8Adapter(VanillaBpProperties properties, DeploymentService deploymentService, Camunda8TaskWiring camunda8TaskWiring) {
        return new Camunda8DeploymentAdapter(this.applicationName, properties, this.camunda8Properties, deploymentService, camunda8TaskWiring);
    }

    @Bean
    public Camunda8TaskWiring camunda8TaskWiring(SpringDataUtil springDataUtil, SpringBeanUtil springBeanUtil, Camunda8UserTaskHandler userTaskHandler, ObjectProvider<Camunda8TaskHandler> taskHandlers) {
        return new Camunda8TaskWiring(springDataUtil, this.applicationContext, springBeanUtil, this.workerId, this.camunda8Properties, userTaskHandler, taskHandlers, this.getConnectableServices());
    }

    @Bean
    public DeploymentService c8DeploymentService(DeploymentPersistence persistence) {
        return new DeploymentService(persistence);
    }

    @Bean
    public Camunda8UserTaskHandler userTaskHandler() {
        return new Camunda8UserTaskHandler(this.workerId);
    }

    @Bean
    @Scope(value="prototype")
    public Camunda8TaskHandler camunda8TaskHandler(SpringDataUtil springDataUtil, CrudRepository<Object, Object> repository, Camunda8Connectable.Type taskType, String taskDefinition, Object bean, Method method, List<MethodParameter> parameters, String idPropertyName, String tenantId, String workflowModuleId, String bpmnProcessId) {
        return new Camunda8TaskHandler(taskType, repository, bean, method, parameters, idPropertyName, tenantId, workflowModuleId, bpmnProcessId, this.camunda8Properties.isTaskIdAsHexString(workflowModuleId));
    }

    public <DE> Camunda8ProcessService<?> newProcessServiceImplementation(SpringDataUtil springDataUtil, Class<DE> workflowAggregateClass, Class<?> workflowAggregateIdClass, CrudRepository<DE, Object> workflowAggregateRepository) {
        Camunda8ProcessService<Object> result = new Camunda8ProcessService<Object>(this.camunda8Properties, this.eventPublisher, workflowAggregateRepository, arg_0 -> ((SpringDataUtil)springDataUtil).getId(arg_0), workflowAggregateClass);
        this.putConnectableService(workflowAggregateClass, result);
        return result;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringBeanUtil vanillabpSpringBeanUtil(ApplicationContext applicationContext) {
        return new SpringBeanUtil(applicationContext);
    }

    @Bean
    public Camunda8TransactionProcessor camunda8TransactionProcessor() {
        return new Camunda8TransactionProcessor();
    }
}

