/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment;

import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.vanillabp.camunda8.deployment.DeployedBpmn;
import io.vanillabp.camunda8.deployment.DeployedProcess;
import io.vanillabp.camunda8.deployment.Deployment;
import io.vanillabp.camunda8.deployment.DeploymentPersistence;
import io.vanillabp.camunda8.deployment.DeploymentResource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DeploymentService {
    private final DeploymentPersistence persistence;

    public DeploymentService(DeploymentPersistence persistence) {
        this.persistence = persistence;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Retryable(retryFor={OptimisticLockingFailureException.class, ObjectOptimisticLockingFailureException.class}, maxAttempts=100, backoff=@Backoff(delay=200L, maxDelay=1000L, multiplier=1.5, random=true))
    public DeployedBpmn addBpmn(BpmnModelInstance model, int fileId, String resourceName) {
        Optional<? extends DeploymentResource> previous = this.persistence.findDeploymentResource(fileId);
        if (previous.isPresent()) {
            return (DeployedBpmn)previous.get();
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)model);
        return this.persistence.addDeployedBpmn(fileId, resourceName, outStream.toByteArray());
    }

    @Recover
    public DeployedBpmn recoverAddBpmn(OptimisticLockingFailureException exception, BpmnModelInstance model, int fileId, String resourceName) {
        return this.staleRecoverAddBpmn((Exception)exception, model, fileId, resourceName);
    }

    @Recover
    public DeployedBpmn recoverAddBpmn(ObjectOptimisticLockingFailureException exception, BpmnModelInstance model, int fileId, String resourceName) {
        return this.staleRecoverAddBpmn((Exception)exception, model, fileId, resourceName);
    }

    private DeployedBpmn staleRecoverAddBpmn(Exception exception, BpmnModelInstance model, int fileId, String resourceName) {
        throw new RuntimeException("Could not save BPMN '" + resourceName + "' in local DB due to stale OptimisticLockingFailureException", exception);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @Retryable(retryFor={OptimisticLockingFailureException.class, ObjectOptimisticLockingFailureException.class}, maxAttempts=100, backoff=@Backoff(delay=200L, maxDelay=1000L, multiplier=1.5, random=true))
    public DeployedProcess addProcess(String workflowModuleId, int packageId, Process camunda8DeployedProcess, DeployedBpmn bpmn) {
        long versionedId = camunda8DeployedProcess.getProcessDefinitionKey();
        Optional<? extends Deployment> previous = this.persistence.findDeployedProcess(versionedId);
        if (previous.isPresent() && previous.get().getVersion() == camunda8DeployedProcess.getVersion()) {
            DeployedProcess result = (DeployedProcess)previous.get();
            if (result.getWorkflowModuleId() == null) {
                result = this.persistence.updateMissingWorkflowModuleIdOfDeployedProcess(result, workflowModuleId);
            }
            return result;
        }
        return this.persistence.addDeployedProcess(versionedId, camunda8DeployedProcess.getVersion(), packageId, workflowModuleId, camunda8DeployedProcess.getBpmnProcessId(), bpmn, OffsetDateTime.now());
    }

    @Recover
    public DeployedProcess recoverAddProcess(OptimisticLockingFailureException exception, String workflowModuleId, int packageId, Process camunda8DeployedProcess, DeployedBpmn bpmn) {
        return this.staleRecoverAddProcess((Exception)exception, workflowModuleId, packageId, camunda8DeployedProcess, bpmn);
    }

    @Recover
    public DeployedProcess recoverAddProcess(ObjectOptimisticLockingFailureException exception, String workflowModuleId, int packageId, Process camunda8DeployedProcess, DeployedBpmn bpmn) {
        return this.staleRecoverAddProcess((Exception)exception, workflowModuleId, packageId, camunda8DeployedProcess, bpmn);
    }

    private DeployedProcess staleRecoverAddProcess(Exception exception, String workflowModuleId, int packageId, Process camunda8DeployedProcess, DeployedBpmn bpmn) {
        throw new RuntimeException("Could not save Process '" + camunda8DeployedProcess.getBpmnProcessId() + "' of workflow module '" + workflowModuleId + "' in local DB due to stale OptimisticLockingFailureException", exception);
    }

    public List<? extends DeployedBpmn> getBpmnNotOfPackage(String workflowModuleId, int packageId) {
        return this.persistence.getBpmnNotOfPackage(workflowModuleId, packageId);
    }
}

