/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda8.deployment.jpa;

import io.vanillabp.camunda8.deployment.jpa.DeployedBpmn;
import io.vanillabp.camunda8.deployment.jpa.DeployedProcess;
import io.vanillabp.camunda8.deployment.jpa.Deployment;
import io.vanillabp.camunda8.deployment.jpa.DeploymentResource;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;

@Configuration
@ConditionalOnClass(value={PersistenceManagedTypes.class})
@AutoConfigureBefore(value={HibernateJpaAutoConfiguration.class})
public class JpaDeploymentEntityConfiguration {
    @Bean
    public BeanPostProcessor camunda8JpaBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (!(bean instanceof PersistenceManagedTypes)) {
                    return bean;
                }
                PersistenceManagedTypes pmt = (PersistenceManagedTypes)bean;
                List classNames = pmt.getManagedClassNames();
                classNames.add(DeploymentResource.class.getName());
                classNames.add(DeployedBpmn.class.getName());
                classNames.add(Deployment.class.getName());
                classNames.add(DeployedProcess.class.getName());
                return bean;
            }
        };
    }
}

