/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.webmodeler.cli;

import java.io.File;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.camunda.community.webmodeler.cli.AbstractCommand;
import org.camunda.community.webmodeler.download.Downloader;
import picocli.CommandLine;

@CommandLine.Command(name="downloadProject", description={"Downloads all files of the project."}, mixinStandardHelpOptions=true)
public class DownloadProjectCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--project", "-p"}, description={"project UUID"}, scope=CommandLine.ScopeType.LOCAL, required=true)
    private UUID projectUUID;
    @CommandLine.Option(names={"--output", "-o"}, description={"output folder"}, scope=CommandLine.ScopeType.LOCAL)
    private String output;
    @CommandLine.Option(names={"--mode", "-m"}, description={"Overwrite mode for download. Valid values are: ${COMPLETION-CANDIDATES}"}, defaultValue="SIMPLE_PATH", scope=CommandLine.ScopeType.LOCAL)
    private Downloader.Mode mode;

    @Override
    public Integer call() throws Exception {
        File folder;
        if (this.output == null) {
            folder = new File(".");
        } else {
            folder = new File(this.output);
            FileUtils.forceMkdir((File)folder);
        }
        Downloader downloader = new Downloader(this.parent.buildFilesClient(), folder);
        downloader.downloadProject(this.projectUUID, this.mode);
        return 0;
    }
}

