/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.webmodeler.download;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.camunda.community.webmodeler.client.api.FilesApi;
import org.camunda.community.webmodeler.client.dto.FileDto;
import org.camunda.community.webmodeler.client.dto.FileMetadataDto;
import org.camunda.community.webmodeler.client.invoker.ApiException;

public class Downloader {
    private final FilesApi filesApi;
    private final File folder;

    public Downloader(FilesApi filesApi, File folder) {
        this.filesApi = Objects.requireNonNull(filesApi);
        this.folder = Objects.requireNonNull(folder);
    }

    public void downloadProject(UUID projectUUID, Mode mode) throws ApiException {
        List fileMetadataDto = this.filesApi.listFiles(projectUUID);
        Map<String, FileDto> idToFile = fileMetadataDto.stream().map(this::getFile).collect(Collectors.toMap(item -> item.getMetadata().getId(), item -> item));
        if (Mode.SIMPLE_PATH.equals((Object)mode)) {
            this.writeFilesSimplePath(idToFile);
        } else if (Mode.CANONICAL_PATH.equals((Object)mode)) {
            this.writeFilesCanonicalPath(idToFile);
        } else {
            throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)mode));
        }
    }

    private void writeFilesSimplePath(Map<String, FileDto> idToFile) {
        idToFile.values().stream().forEach(file -> this.writeFile(file.getContent(), file.getMetadata().getSimplePath()));
    }

    private void writeFilesCanonicalPath(Map<String, FileDto> idToFile) {
        idToFile.values().stream().forEach(file -> this.writeFile(file.getContent(), this.getCanonicalPath((FileDto)file)));
    }

    private String getCanonicalPath(FileDto file) {
        List pathElements = file.getMetadata().getCanonicalPath();
        String folderPath = pathElements.stream().map(pe -> String.format("%s[%s]", pe.getName(), pe.getId())).collect(Collectors.joining("/", "", "/"));
        String fileName = String.format("%s[%s].%s", file.getMetadata().getName(), file.getMetadata().getId(), this.toExtension(file.getMetadata().getType()));
        return folderPath + fileName;
    }

    private String toExtension(String type) {
        if ("CONNECTOR_TEMPLATE".equalsIgnoreCase(type)) {
            return "json";
        }
        return type.toLowerCase();
    }

    private void writeFile(String content, String fileName) {
        System.out.println("Writing: " + fileName);
        File outputFile = new File(this.folder, fileName);
        try {
            FileUtils.write((File)outputFile, (CharSequence)content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FileDto getFile(FileMetadataDto fileMetadata) {
        try {
            return this.getFile(UUID.fromString(fileMetadata.getId()));
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public FileDto getFile(UUID fileUUID) throws ApiException {
        return this.filesApi.getFile(fileUUID);
    }

    public static enum Mode {
        SIMPLE_PATH,
        CANONICAL_PATH;

    }
}

