/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.webmodeler.cli;

import org.camunda.community.webmodeler.cli.DownloadFileCommand;
import org.camunda.community.webmodeler.cli.DownloadProjectCommand;
import org.camunda.community.webmodeler.cli.InfoCommand;
import org.camunda.community.webmodeler.cli.ListFilesCommand;
import org.camunda.community.webmodeler.cli.ListProjectsCommand;
import org.camunda.community.webmodeler.client.api.CollaboratorsApi;
import org.camunda.community.webmodeler.client.api.FilesApi;
import org.camunda.community.webmodeler.client.api.FoldersApi;
import org.camunda.community.webmodeler.client.api.InfoApi;
import org.camunda.community.webmodeler.client.api.MilestonesApi;
import org.camunda.community.webmodeler.client.api.ProjectsApi;
import org.camunda.community.webmodeler.client.invoker.ApiClient;
import picocli.CommandLine;

@CommandLine.Command(description={"Web Modeler CLI"}, mixinStandardHelpOptions=true)
public class CommandLineApp {
    public static final int MAX_PAGE_SIZE = 50;
    @CommandLine.Option(names={"--token", "-t"}, description={"JWT token"}, scope=CommandLine.ScopeType.INHERIT, required=true)
    private String token;
    @CommandLine.Option(names={"--basePath", "-b"}, description={"base path of API (default to Camunda Cloud path)"}, scope=CommandLine.ScopeType.INHERIT)
    private String basePath = new ApiClient().getBasePath();

    protected CollaboratorsApi buildCollaboratorsClient() {
        CollaboratorsApi result = new CollaboratorsApi();
        ApiClient apiClient = result.getApiClient();
        this.configureClient(apiClient);
        return result;
    }

    protected FilesApi buildFilesClient() {
        FilesApi result = new FilesApi();
        ApiClient apiClient = result.getApiClient();
        this.configureClient(apiClient);
        return result;
    }

    protected FoldersApi buildFoldersClient() {
        FoldersApi result = new FoldersApi();
        ApiClient apiClient = result.getApiClient();
        this.configureClient(apiClient);
        return result;
    }

    protected InfoApi buildInfoClient() {
        InfoApi result = new InfoApi();
        ApiClient apiClient = result.getApiClient();
        this.configureClient(apiClient);
        return result;
    }

    protected MilestonesApi buildMilestonesClient() {
        MilestonesApi result = new MilestonesApi();
        ApiClient apiClient = result.getApiClient();
        this.configureClient(apiClient);
        return result;
    }

    protected ProjectsApi buildProjectsClient() {
        ProjectsApi result = new ProjectsApi();
        ApiClient apiClient = result.getApiClient();
        this.configureClient(apiClient);
        return result;
    }

    private void configureClient(ApiClient apiClient) {
        apiClient.setBearerToken(this.token);
        apiClient.setBasePath(this.basePath);
    }

    public static void main(String[] args) {
        new CommandLine((Object)new CommandLineApp()).addSubcommand(InfoCommand.class).addSubcommand(ListProjectsCommand.class).addSubcommand(ListFilesCommand.class).addSubcommand(DownloadFileCommand.class).addSubcommand(DownloadProjectCommand.class).execute(args);
    }
}

