/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.webmodeler.client.springboot;

import io.camunda.operate.auth.copy.AuthInterface;
import io.camunda.operate.auth.copy.SaasAuthentication;
import org.camunda.community.webmodeler.client.invoker.ApiClient;
import org.camunda.community.webmodeler.client.springboot.CamundaWebModelerApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CamundaWebModelerClientStarter {
    @Value(value="${camunda.bpm.client.baseUrl:https://modeler.cloud.camunda.io/api/beta/}")
    private String basePath;
    @Value(value="${camunda.bpm.client.authUrl:https://login.cloud.camunda.io/oauth/token/}")
    private String oauthUrl;
    @Value(value="${camunda.bpm.client.oauthAudience:api.cloud.camunda.io}")
    private String oauthAudience;
    @Value(value="${camunda.modeler.client.clientId}")
    private String clientId;
    @Value(value="${camunda.modeler.client.clientSecret}")
    private String clientSecret;
    private AuthInterface authInterface;

    @Bean
    public CamundaWebModelerApi createCamundaWebModelerApi(ApiClient client) {
        return new CamundaWebModelerApi(client);
    }

    @Bean
    public ApiClient createApiClient() {
        ApiClient client = new ApiClient();
        this.authInterface = new SaasAuthentication(this.oauthUrl, this.oauthAudience, this.clientId, this.clientSecret);
        this.authInterface.authenticate(client);
        return client;
    }
}

