/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.webmodeler.client.springboot;

import io.camunda.operate.auth.copy.SaasAuthentication;
import org.camunda.community.webmodeler.client.invoker.ApiClient;
import org.camunda.community.webmodeler.client.springboot.CamundaWebModelerApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CamundaWebModelerClientStarter {
    @Value(value="${camunda.modeler.client.baseUrl:https://modeler.cloud.camunda.io}")
    private String basePath;
    @Value(value="${camunda.modeler.client.oAuthUrl:https://login.cloud.camunda.io/oauth/token/}")
    private String oAuthUrl;
    @Value(value="${camunda.modeler.client.oAuthAudience:api.cloud.camunda.io}")
    private String oAuthAudience;
    @Value(value="${camunda.modeler.client.clientId}")
    private String clientId;
    @Value(value="${camunda.modeler.client.clientSecret}")
    private String clientSecret;

    @Bean
    public CamundaWebModelerApi createCamundaWebModelerApi(ApiClient client) {
        return new CamundaWebModelerApi(client);
    }

    @Bean
    public ApiClient createApiClient() {
        ApiClient client = new ApiClient();
        client.setBasePath(this.basePath);
        SaasAuthentication authInterface = new SaasAuthentication(this.oAuthUrl, this.oAuthAudience, this.clientId, this.clientSecret);
        authInterface.authenticate(client);
        return client;
    }
}

