/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.rest;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.zeebe.play.connectors.ConnectorService;
import org.camunda.community.zeebe.play.rest.ProcessesResource;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/processes"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\t\u001a\u00020\bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/camunda/community/zeebe/play/rest/ProcessesResource;", "", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "connectorService", "Lorg/camunda/community/zeebe/play/connectors/ConnectorService;", "(Lio/camunda/zeebe/client/ZeebeClient;Lorg/camunda/community/zeebe/play/connectors/ConnectorService;)V", "createInstance", "", "processKey", "variables", "", "findMissingConnectorSecrets", "Lorg/camunda/community/zeebe/play/rest/ProcessesResource$MissingConnectorSecretsDto;", "MissingConnectorSecretsDto", "zeebe-play"})
public class ProcessesResource {
    @NotNull
    private final ZeebeClient zeebeClient;
    @NotNull
    private final ConnectorService connectorService;

    public ProcessesResource(@NotNull ZeebeClient zeebeClient, @NotNull ConnectorService connectorService) {
        Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
        Intrinsics.checkNotNullParameter((Object)connectorService, (String)"connectorService");
        this.zeebeClient = zeebeClient;
        this.connectorService = connectorService;
    }

    @RequestMapping(path={"/{processKey}"}, method={RequestMethod.POST})
    public long createInstance(@PathVariable(value="processKey") long processKey, @RequestBody @NotNull String variables) {
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        return ((ProcessInstanceEvent)this.zeebeClient.newCreateInstanceCommand().processDefinitionKey(processKey).variables(variables).send().join()).getProcessInstanceKey();
    }

    @RequestMapping(path={"/{processKey}/missing-connector-secrets"}, method={RequestMethod.GET})
    @NotNull
    public MissingConnectorSecretsDto findMissingConnectorSecrets(@PathVariable(value="processKey") long processKey) {
        return new MissingConnectorSecretsDto(this.connectorService.getMissingConnectorSecrets(processKey));
    }
}

