/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.rest;

import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.util.outbound.ConnectorJobHandler;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.zeebe.play.connectors.ConnectorService;
import org.camunda.community.zeebe.play.connectors.ConnectorsSecretProvider;
import org.camunda.community.zeebe.play.rest.ConnectorsResource;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/rest/connectors"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J$\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0012J\b\u0010\u0015\u001a\u00020\u0016H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/camunda/community/zeebe/play/rest/ConnectorsResource;", "", "connectorService", "Lorg/camunda/community/zeebe/play/connectors/ConnectorService;", "connectorsSecretProvider", "Lorg/camunda/community/zeebe/play/connectors/ConnectorsSecretProvider;", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "(Lorg/camunda/community/zeebe/play/connectors/ConnectorService;Lorg/camunda/community/zeebe/play/connectors/ConnectorsSecretProvider;Lio/camunda/zeebe/client/ZeebeClient;)V", "executeJob", "", "jobType", "", "jobKey", "", "findConnectorJob", "Lio/camunda/zeebe/client/api/response/ActivatedJob;", "connectorConfig", "Lio/camunda/connector/impl/outbound/OutboundConnectorConfiguration;", "attempt", "", "getAvailableConnectors", "Lorg/camunda/community/zeebe/play/rest/ConnectorsResource$ConnectorsDto;", "ConnectDto", "ConnectorsDto", "zeebe-play"})
@SourceDebugExtension(value={"SMAP\nConnectorsResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectorsResource.kt\norg/camunda/community/zeebe/play/rest/ConnectorsResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1547#2:79\n1618#2,3:80\n1#3:83\n*S KotlinDebug\n*F\n+ 1 ConnectorsResource.kt\norg/camunda/community/zeebe/play/rest/ConnectorsResource\n*L\n28#1:79\n28#1:80,3\n*E\n"})
public class ConnectorsResource {
    @NotNull
    private final ConnectorService connectorService;
    @NotNull
    private final ConnectorsSecretProvider connectorsSecretProvider;
    @NotNull
    private final ZeebeClient zeebeClient;

    public ConnectorsResource(@NotNull ConnectorService connectorService, @NotNull ConnectorsSecretProvider connectorsSecretProvider, @NotNull ZeebeClient zeebeClient) {
        Intrinsics.checkNotNullParameter((Object)connectorService, (String)"connectorService");
        Intrinsics.checkNotNullParameter((Object)connectorsSecretProvider, (String)"connectorsSecretProvider");
        Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
        this.connectorService = connectorService;
        this.connectorsSecretProvider = connectorsSecretProvider;
        this.zeebeClient = zeebeClient;
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(method={RequestMethod.GET})
    @NotNull
    public ConnectorsDto getAvailableConnectors() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.connectorService.findAvailableConnectors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OutboundConnectorConfiguration outboundConnectorConfiguration = (OutboundConnectorConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            String string2 = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.type");
            collection.add(new ConnectDto(string, string2));
        }
        List list = (List)destination$iv$iv;
        return new ConnectorsDto(list);
    }

    @RequestMapping(path={"/{jobType}/execute/{jobKey}"}, method={RequestMethod.POST})
    public void executeJob(@PathVariable(value="jobType") @NotNull String jobType, @PathVariable(value="jobKey") long jobKey) {
        Unit unit;
        Object v0;
        Iterable iterable;
        block5: {
            Intrinsics.checkNotNullParameter((Object)jobType, (String)"jobType");
            iterable = this.connectorService.findAvailableConnectors();
            for (Object t : iterable) {
                OutboundConnectorConfiguration it = (OutboundConnectorConfiguration)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)jobType)) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        OutboundConnectorConfiguration outboundConnectorConfiguration = v0;
        if (outboundConnectorConfiguration == null) {
            throw new RuntimeException("No connector found with job type '" + jobType + "'.");
        }
        OutboundConnectorConfiguration connectorConfig = outboundConnectorConfiguration;
        ConnectorJobHandler jobHandler = new ConnectorJobHandler(connectorConfig.getFunction(), (SecretProvider)this.connectorsSecretProvider);
        iterable = ConnectorsResource.findConnectorJob$default((ConnectorsResource)this, (OutboundConnectorConfiguration)connectorConfig, (long)jobKey, (int)0, (int)4, null);
        if (iterable != null) {
            Iterable it = iterable;
            boolean bl = false;
            jobHandler.handle((JobClient)this.zeebeClient, (ActivatedJob)it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new RuntimeException("No job found with key '" + jobKey + "'.");
        }
    }

    private ActivatedJob findConnectorJob(OutboundConnectorConfiguration connectorConfig, long jobKey, int attempt) {
        Object v2;
        block2: {
            ActivateJobsCommandStep1.ActivateJobsCommandStep3 activateJobsCommandStep3 = this.zeebeClient.newActivateJobsCommand().jobType(connectorConfig.getType()).maxJobsToActivate(attempt * 100).workerName(connectorConfig.getName());
            String[] stringArray = connectorConfig.getInputVariables();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"connectorConfig.inputVariables");
            List list = ((ActivateJobsResponse)activateJobsCommandStep3.fetchVariables(ArraysKt.toList((Object[])stringArray)).timeout(Duration.ofSeconds(1L)).send().join()).getJobs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"zeebeClient\n            \u2026.join()\n            .jobs");
            Iterable iterable = list;
            for (Object t : iterable) {
                ActivatedJob it = (ActivatedJob)t;
                boolean bl = false;
                if (!(it.getKey() == jobKey)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        ActivatedJob job = v2;
        if (job == null && attempt <= 5) {
            return this.findConnectorJob(connectorConfig, jobKey, attempt + 1);
        }
        return job;
    }

    static /* synthetic */ ActivatedJob findConnectorJob$default(ConnectorsResource connectorsResource, OutboundConnectorConfiguration outboundConnectorConfiguration, long l, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findConnectorJob");
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return connectorsResource.findConnectorJob(outboundConnectorConfiguration, l, n);
    }
}

