/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.zeebe;

import io.camunda.zeebe.client.ZeebeClient;
import io.zeebe.hazelcast.exporter.HazelcastExporter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.eze.EngineFactory;
import org.camunda.community.eze.ZeebeEngine;
import org.camunda.community.zeebe.play.zeebe.EmbeddedZeebeConfig;
import org.camunda.community.zeebe.play.zeebe.ZeebeService;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"zeebe.engine"}, havingValue="embedded", matchIfMissing=true)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0017J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0004H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/camunda/community/zeebe/play/zeebe/EmbeddedZeebeConfig;", "", "()V", "embeddedZeebeEngine", "Lorg/camunda/community/eze/ZeebeEngine;", "embeddedZeebeService", "Lorg/camunda/community/zeebe/play/zeebe/ZeebeService;", "engine", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "EmbeddedZeebeService", "zeebe-play"})
public class EmbeddedZeebeConfig {
    @Bean
    @NotNull
    public ZeebeService embeddedZeebeService(@NotNull ZeebeEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return (ZeebeService)new EmbeddedZeebeService(engine);
    }

    @Bean
    @NotNull
    public ZeebeEngine embeddedZeebeEngine() {
        return EngineFactory.INSTANCE.create((Iterable)CollectionsKt.listOf((Object)new HazelcastExporter()));
    }

    @Bean
    @NotNull
    public ZeebeClient zeebeClient(@NotNull ZeebeEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine.createClient();
    }
}

