/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.connectors;

import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.util.discovery.SPIConnectorDiscovery;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeInput;
import io.zeebe.zeeqs.data.entity.Process;
import io.zeebe.zeeqs.data.repository.ProcessRepository;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.camunda.community.zeebe.play.connectors.ConnectorSecret;
import org.camunda.community.zeebe.play.connectors.ConnectorSecretRepository;
import org.camunda.community.zeebe.play.connectors.ConnectorService;
import org.jetbrains.annotations.NotNull;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Controller;

@Controller
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\rH\u0012J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/camunda/community/zeebe/play/connectors/ConnectorService;", "", "processRepository", "Lio/zeebe/zeeqs/data/repository/ProcessRepository;", "connectorSecretRepository", "Lorg/camunda/community/zeebe/play/connectors/ConnectorSecretRepository;", "(Lio/zeebe/zeeqs/data/repository/ProcessRepository;Lorg/camunda/community/zeebe/play/connectors/ConnectorSecretRepository;)V", "secretRegex", "Lkotlin/text/Regex;", "findAvailableConnectors", "", "Lio/camunda/connector/impl/outbound/OutboundConnectorConfiguration;", "findReferencedSecrets", "", "text", "getBpmnModel", "Lio/camunda/zeebe/model/bpmn/BpmnModelInstance;", "processDefinitionKey", "", "getMissingConnectorSecrets", "getReferencedConnectorSecrets", "zeebe-play"})
@SourceDebugExtension(value={"SMAP\nConnectorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectorService.kt\norg/camunda/community/zeebe/play/connectors/ConnectorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1549#2:62\n1620#2,3:63\n819#2:66\n847#2,2:67\n1549#2:69\n1620#2,3:70\n1360#2:73\n1446#2,5:74\n1#3:79\n*S KotlinDebug\n*F\n+ 1 ConnectorService.kt\norg/camunda/community/zeebe/play/connectors/ConnectorService\n*L\n28#1:62\n28#1:63,3\n30#1:66\n30#1:67,2\n37#1:69\n37#1:70,3\n38#1:73\n38#1:74,5\n*E\n"})
public class ConnectorService {
    @NotNull
    private final ProcessRepository processRepository;
    @NotNull
    private final ConnectorSecretRepository connectorSecretRepository;
    @NotNull
    private final Regex secretRegex;

    public ConnectorService(@NotNull ProcessRepository processRepository, @NotNull ConnectorSecretRepository connectorSecretRepository) {
        Intrinsics.checkNotNullParameter((Object)processRepository, (String)"processRepository");
        Intrinsics.checkNotNullParameter((Object)connectorSecretRepository, (String)"connectorSecretRepository");
        this.processRepository = processRepository;
        this.connectorSecretRepository = connectorSecretRepository;
        this.secretRegex = new Regex("[\"|{]?secrets\\.(\\w+)[\"|}]?");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getMissingConnectorSecrets(long processDefinitionKey) {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        List referencedSecrets = this.getReferencedConnectorSecrets(processDefinitionKey);
        Iterable iterable = this.connectorSecretRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"connectorSecretRepository.findAll()");
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ConnectorSecret connectorSecret = (ConnectorSecret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List existingSecrets = (List)destination$iv$iv;
        Iterable $this$filterNot$iv = referencedSecrets;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (existingSecrets.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Cacheable(cacheNames={"processConnectorSecrets"})
    @NotNull
    public List<String> getReferencedConnectorSecrets(long processDefinitionKey) {
        List list;
        Collection collection;
        BpmnModelInstance bpmnModelInstance = this.getBpmnModel(processDefinitionKey);
        if (bpmnModelInstance != null && (collection = bpmnModelInstance.getModelElementsByType(ZeebeInput.class)) != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = collection;
            boolean $i$f$map22 = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ZeebeInput zeebeInput = (ZeebeInput)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getSource());
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Iterable list$iv$iv = this.findReferencedSecrets(it);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
            if (list2 != null) {
                list = list2;
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    private BpmnModelInstance getBpmnModel(long processDefinitionKey) {
        BpmnModelInstance bpmnModelInstance;
        String string;
        Process process = (Process)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.processRepository), (Object)processDefinitionKey);
        if (process != null && (string = process.getBpmnXML()) != null) {
            String string2 = string;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            ByteArrayInputStream it = new ByteArrayInputStream(byArray);
            boolean bl = false;
            bpmnModelInstance = Bpmn.readModelFromStream((InputStream)it);
        } else {
            bpmnModelInstance = null;
        }
        return bpmnModelInstance;
    }

    private List<String> findReferencedSecrets(String text) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.secretRegex, (CharSequence)text, (int)0, (int)2, null), (Function1)((Function1)findReferencedSecrets.1.INSTANCE)));
    }

    @NotNull
    public List<OutboundConnectorConfiguration> findAvailableConnectors() {
        List list = SPIConnectorDiscovery.discoverOutbound();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"discoverOutbound()");
        return CollectionsKt.toList((Iterable)list);
    }
}

