/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.util.ConnectorHelper;
import io.camunda.connector.runtime.util.outbound.ConnectorJobHandler;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.zeebe.zeeqs.data.entity.ElementInstance;
import io.zeebe.zeeqs.data.entity.Job;
import io.zeebe.zeeqs.data.entity.JobState;
import io.zeebe.zeeqs.data.entity.Process;
import io.zeebe.zeeqs.data.entity.Variable;
import io.zeebe.zeeqs.data.repository.ElementInstanceRepository;
import io.zeebe.zeeqs.data.repository.JobRepository;
import io.zeebe.zeeqs.data.repository.ProcessRepository;
import io.zeebe.zeeqs.data.service.VariableService;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.zeebe.play.connectors.ConnectorService;
import org.camunda.community.zeebe.play.connectors.ConnectorsSecretProvider;
import org.camunda.community.zeebe.play.rest.ConnectorsResource;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/connectors"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 '2\u00020\u0001:\u0004'()*B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u0016H\u0017J$\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00162\b\b\u0002\u0010 \u001a\u00020!H\u0012J\b\u0010\"\u001a\u00020#H\u0017J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/camunda/community/zeebe/play/rest/ConnectorsResource;", "", "connectorService", "Lorg/camunda/community/zeebe/play/connectors/ConnectorService;", "connectorsSecretProvider", "Lorg/camunda/community/zeebe/play/connectors/ConnectorsSecretProvider;", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "jobRepository", "Lio/zeebe/zeeqs/data/repository/JobRepository;", "processRepository", "Lio/zeebe/zeeqs/data/repository/ProcessRepository;", "elementInstanceRepository", "Lio/zeebe/zeeqs/data/repository/ElementInstanceRepository;", "variableService", "Lio/zeebe/zeeqs/data/service/VariableService;", "(Lorg/camunda/community/zeebe/play/connectors/ConnectorService;Lorg/camunda/community/zeebe/play/connectors/ConnectorsSecretProvider;Lio/camunda/zeebe/client/ZeebeClient;Lio/zeebe/zeeqs/data/repository/JobRepository;Lio/zeebe/zeeqs/data/repository/ProcessRepository;Lio/zeebe/zeeqs/data/repository/ElementInstanceRepository;Lio/zeebe/zeeqs/data/service/VariableService;)V", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "keysOfPendingJobs", "Ljava/util/concurrent/CopyOnWriteArrayList;", "", "executeJob", "", "jobType", "", "jobKey", "findConnectorJob", "Lio/camunda/zeebe/client/api/response/ActivatedJob;", "connectorConfig", "Lio/camunda/connector/impl/outbound/OutboundConnectorConfiguration;", "attempt", "", "getAvailableConnectors", "Lorg/camunda/community/zeebe/play/rest/ConnectorsResource$ConnectorsDto;", "getJobVariables", "job", "Lio/zeebe/zeeqs/data/entity/Job;", "Companion", "ConnectDto", "ConnectorsDto", "FakeActivatedJob", "zeebe-play"})
@SourceDebugExtension(value={"SMAP\nConnectorsResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectorsResource.kt\norg/camunda/community/zeebe/play/rest/ConnectorsResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1549#2:230\n1620#2,3:231\n766#2:235\n857#2,2:236\n1#3:234\n*S KotlinDebug\n*F\n+ 1 ConnectorsResource.kt\norg/camunda/community/zeebe/play/rest/ConnectorsResource\n*L\n58#1:230\n58#1:231,3\n104#1:235\n104#1:236,2\n*E\n"})
public class ConnectorsResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectorService connectorService;
    @NotNull
    private final ConnectorsSecretProvider connectorsSecretProvider;
    @NotNull
    private final ZeebeClient zeebeClient;
    @NotNull
    private final JobRepository jobRepository;
    @NotNull
    private final ProcessRepository processRepository;
    @NotNull
    private final ElementInstanceRepository elementInstanceRepository;
    @NotNull
    private final VariableService variableService;
    private final ScheduledExecutorService executor;
    @NotNull
    private final CopyOnWriteArrayList<Long> keysOfPendingJobs;
    @NotNull
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public ConnectorsResource(@NotNull ConnectorService connectorService, @NotNull ConnectorsSecretProvider connectorsSecretProvider, @NotNull ZeebeClient zeebeClient, @NotNull JobRepository jobRepository, @NotNull ProcessRepository processRepository, @NotNull ElementInstanceRepository elementInstanceRepository, @NotNull VariableService variableService) {
        Intrinsics.checkNotNullParameter((Object)connectorService, (String)"connectorService");
        Intrinsics.checkNotNullParameter((Object)connectorsSecretProvider, (String)"connectorsSecretProvider");
        Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
        Intrinsics.checkNotNullParameter((Object)jobRepository, (String)"jobRepository");
        Intrinsics.checkNotNullParameter((Object)processRepository, (String)"processRepository");
        Intrinsics.checkNotNullParameter((Object)elementInstanceRepository, (String)"elementInstanceRepository");
        Intrinsics.checkNotNullParameter((Object)variableService, (String)"variableService");
        this.connectorService = connectorService;
        this.connectorsSecretProvider = connectorsSecretProvider;
        this.zeebeClient = zeebeClient;
        this.jobRepository = jobRepository;
        this.processRepository = processRepository;
        this.elementInstanceRepository = elementInstanceRepository;
        this.variableService = variableService;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.keysOfPendingJobs = new CopyOnWriteArrayList();
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(method={RequestMethod.GET})
    @NotNull
    public ConnectorsDto getAvailableConnectors() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.connectorService.findAvailableConnectors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OutboundConnectorConfiguration outboundConnectorConfiguration = (OutboundConnectorConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            String string2 = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.type");
            collection.add(new ConnectDto(string, string2));
        }
        List list = (List)destination$iv$iv;
        return new ConnectorsDto(list);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @RequestMapping(path={"/{jobType}/execute/{jobKey}"}, method={RequestMethod.POST})
    public void executeJob(@PathVariable(value="jobType") @NotNull String jobType, @PathVariable(value="jobKey") long jobKey) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)jobType, (String)"jobType");
            var7_3 = this.connectorService.findAvailableConnectors();
            for (T var9_5 : var7_3) {
                it = (OutboundConnectorConfiguration)var9_5 /* !! */ ;
                $i$a$-find-ConnectorsResource$executeJob$connectorConfig$1 = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)jobType)) continue;
                v0 = var9_5 /* !! */ ;
                break block5;
            }
            v0 = null;
        }
        v1 = v0;
        if (v1 == null) {
            throw new RuntimeException("No connector found with job type '" + jobType + "'.");
        }
        connectorConfig = v1;
        connector = (OutboundConnectorFunction)ConnectorHelper.instantiateConnector((Class)connectorConfig.getConnectorClass());
        jobHandler = new ConnectorJobHandler(connector, (SecretProvider)this.connectorsSecretProvider);
        var8_4 = (Job)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.jobRepository), (Object)jobKey);
        if (var8_4 == null) ** GOTO lbl-1000
        it = var10_6 = var8_4;
        $i$a$-takeIf-ConnectorsResource$executeJob$1 = false;
        v2 /* !! */  = var9_5 /* !! */  = (it.getState() == JobState.ACTIVATABLE && this.keysOfPendingJobs.contains(jobKey) == false) != false ? var10_6 : null;
        if (var9_5 /* !! */  != null) {
            job /* !! */  = var9_5 /* !! */ ;
            $i$a$-let-ConnectorsResource$executeJob$2 = false;
            it = new FakeActivatedJob(job /* !! */ , (Process)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.processRepository), (Object)job /* !! */ .getProcessDefinitionKey()), (ElementInstance)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.elementInstanceRepository), (Object)job /* !! */ .getElementInstanceKey()), this.getJobVariables(job /* !! */ , connectorConfig));
            $i$a$-let-ConnectorsResource$executeJob$3 = false;
            this.keysOfPendingJobs.add(jobKey);
            jobHandler.handle((JobClient)this.zeebeClient, (ActivatedJob)it);
            v3 = this.executor.schedule((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, executeJob$lambda$5$lambda$4(org.camunda.community.zeebe.play.rest.ConnectorsResource long ), ()V)((ConnectorsResource)this, (long)jobKey), 10L, TimeUnit.SECONDS);
        } else lbl-1000:
        // 2 sources

        {
            v3 = var7_3 = null;
        }
        if (var7_3 == null) {
            throw new RuntimeException("No job found with key '" + jobKey + "'.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getJobVariables(Job job, OutboundConnectorConfiguration connectorConfig) {
        void $this$filterTo$iv$iv;
        List allVariables = this.variableService.getVariables(job.getElementInstanceKey(), false, true);
        Iterable $this$filter$iv = allVariables;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Variable it = (Variable)element$iv$iv;
            boolean bl = false;
            String[] stringArray = connectorConfig.getInputVariables();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"connectorConfig.inputVariables");
            if (!ArraysKt.contains((Object[])stringArray, (Object)it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredVariables = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)filteredVariables, (CharSequence)",", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)((Function1)getJobVariables.1.INSTANCE), (int)24, null);
    }

    private ActivatedJob findConnectorJob(OutboundConnectorConfiguration connectorConfig, long jobKey, int attempt) {
        Object v2;
        block2: {
            ActivateJobsCommandStep1.ActivateJobsCommandStep3 activateJobsCommandStep3 = this.zeebeClient.newActivateJobsCommand().jobType(connectorConfig.getType()).maxJobsToActivate(attempt * 100).workerName(connectorConfig.getName());
            String[] stringArray = connectorConfig.getInputVariables();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"connectorConfig.inputVariables");
            List list = ((ActivateJobsResponse)activateJobsCommandStep3.fetchVariables(ArraysKt.toList((Object[])stringArray)).timeout(Duration.ofSeconds(1L)).send().join()).getJobs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"zeebeClient\n            \u2026.join()\n            .jobs");
            Iterable iterable = list;
            for (Object t : iterable) {
                ActivatedJob it = (ActivatedJob)t;
                boolean bl = false;
                if (!(it.getKey() == jobKey)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        ActivatedJob job = v2;
        if (job == null && attempt <= 5) {
            return this.findConnectorJob(connectorConfig, jobKey, attempt + 1);
        }
        return job;
    }

    static /* synthetic */ ActivatedJob findConnectorJob$default(ConnectorsResource connectorsResource, OutboundConnectorConfiguration outboundConnectorConfiguration, long l, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findConnectorJob");
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return connectorsResource.findConnectorJob(outboundConnectorConfiguration, l, n);
    }

    private static final void executeJob$lambda$5$lambda$4(ConnectorsResource this$0, long $jobKey) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.keysOfPendingJobs.remove($jobKey);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$cp() {
        return objectMapper;
    }
}

