/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.rest;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.BroadcastSignalResponse;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.zeebe.zeeqs.data.entity.MessageCorrelation;
import io.zeebe.zeeqs.data.entity.MessageSubscription;
import io.zeebe.zeeqs.data.entity.Process;
import io.zeebe.zeeqs.data.entity.ProcessInstance;
import io.zeebe.zeeqs.data.entity.ProcessInstanceState;
import io.zeebe.zeeqs.data.entity.SignalSubscription;
import io.zeebe.zeeqs.data.entity.Timer;
import io.zeebe.zeeqs.data.entity.TimerState;
import io.zeebe.zeeqs.data.repository.MessageCorrelationRepository;
import io.zeebe.zeeqs.data.repository.MessageSubscriptionRepository;
import io.zeebe.zeeqs.data.repository.ProcessInstanceRepository;
import io.zeebe.zeeqs.data.repository.ProcessRepository;
import io.zeebe.zeeqs.data.repository.SignalSubscriptionRepository;
import io.zeebe.zeeqs.data.repository.TimerRepository;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.camunda.community.zeebe.play.connectors.ConnectorService;
import org.camunda.community.zeebe.play.rest.ProcessesResource;
import org.camunda.community.zeebe.play.rest.ProcessesResourceKt;
import org.camunda.community.zeebe.play.services.ZeebeClockService;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/processes"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001:\u0001,BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u00192\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0017J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0012J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0012J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0012J \u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0012J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0012J\u0012\u0010$\u001a\u00020%2\b\b\u0001\u0010\u001a\u001a\u00020\u0019H\u0017J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0019H\u0012J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0019H\u0012J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0019H\u0012R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/camunda/community/zeebe/play/rest/ProcessesResource;", "", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "connectorService", "Lorg/camunda/community/zeebe/play/connectors/ConnectorService;", "processRepository", "Lio/zeebe/zeeqs/data/repository/ProcessRepository;", "messageSubscriptionRepository", "Lio/zeebe/zeeqs/data/repository/MessageSubscriptionRepository;", "messageCorrelationRepository", "Lio/zeebe/zeeqs/data/repository/MessageCorrelationRepository;", "signalSubscriptionRepository", "Lio/zeebe/zeeqs/data/repository/SignalSubscriptionRepository;", "processInstanceRepository", "Lio/zeebe/zeeqs/data/repository/ProcessInstanceRepository;", "timerRepository", "Lio/zeebe/zeeqs/data/repository/TimerRepository;", "clockService", "Lorg/camunda/community/zeebe/play/services/ZeebeClockService;", "(Lio/camunda/zeebe/client/ZeebeClient;Lorg/camunda/community/zeebe/play/connectors/ConnectorService;Lio/zeebe/zeeqs/data/repository/ProcessRepository;Lio/zeebe/zeeqs/data/repository/MessageSubscriptionRepository;Lio/zeebe/zeeqs/data/repository/MessageCorrelationRepository;Lio/zeebe/zeeqs/data/repository/SignalSubscriptionRepository;Lio/zeebe/zeeqs/data/repository/ProcessInstanceRepository;Lio/zeebe/zeeqs/data/repository/TimerRepository;Lorg/camunda/community/zeebe/play/services/ZeebeClockService;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "createInstance", "", "processKey", "variables", "", "createProcessInstanceWithMessageStartEvent", "createProcessInstanceWithNoneStartEvent", "createProcessInstanceWithSignalStartEvent", "createProcessInstanceWithStartEvent", "startEvent", "Lio/camunda/zeebe/model/bpmn/instance/StartEvent;", "createProcessInstanceWithTimerStartEvent", "findMissingConnectorSecrets", "Lorg/camunda/community/zeebe/play/rest/ProcessesResource$MissingConnectorSecretsDto;", "getProcessInstanceForTimer", "timerKey", "getProcessInstanceKeyForMessage", "messageKey", "getProcessInstanceKeyForSignal", "signalKey", "MissingConnectorSecretsDto", "zeebe-play"})
@SourceDebugExtension(value={"SMAP\nProcessesResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessesResource.kt\norg/camunda/community/zeebe/play/rest/ProcessesResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n1#2:238\n766#3:239\n857#3,2:240\n1747#3,3:242\n1747#3,3:245\n1747#3,3:248\n288#3,2:251\n288#3,2:253\n288#3,2:255\n*S KotlinDebug\n*F\n+ 1 ProcessesResource.kt\norg/camunda/community/zeebe/play/rest/ProcessesResource\n*L\n49#1:239\n49#1:240,2\n85#1:242,3\n87#1:245,3\n89#1:248,3\n128#1:251,2\n142#1:253,2\n210#1:255,2\n*E\n"})
public class ProcessesResource {
    @NotNull
    private final ZeebeClient zeebeClient;
    @NotNull
    private final ConnectorService connectorService;
    @NotNull
    private final ProcessRepository processRepository;
    @NotNull
    private final MessageSubscriptionRepository messageSubscriptionRepository;
    @NotNull
    private final MessageCorrelationRepository messageCorrelationRepository;
    @NotNull
    private final SignalSubscriptionRepository signalSubscriptionRepository;
    @NotNull
    private final ProcessInstanceRepository processInstanceRepository;
    @NotNull
    private final TimerRepository timerRepository;
    @NotNull
    private final ZeebeClockService clockService;
    private final ExecutorService executor;

    public ProcessesResource(@NotNull ZeebeClient zeebeClient, @NotNull ConnectorService connectorService, @NotNull ProcessRepository processRepository, @NotNull MessageSubscriptionRepository messageSubscriptionRepository, @NotNull MessageCorrelationRepository messageCorrelationRepository, @NotNull SignalSubscriptionRepository signalSubscriptionRepository, @NotNull ProcessInstanceRepository processInstanceRepository, @NotNull TimerRepository timerRepository, @NotNull ZeebeClockService clockService) {
        Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
        Intrinsics.checkNotNullParameter((Object)connectorService, (String)"connectorService");
        Intrinsics.checkNotNullParameter((Object)processRepository, (String)"processRepository");
        Intrinsics.checkNotNullParameter((Object)messageSubscriptionRepository, (String)"messageSubscriptionRepository");
        Intrinsics.checkNotNullParameter((Object)messageCorrelationRepository, (String)"messageCorrelationRepository");
        Intrinsics.checkNotNullParameter((Object)signalSubscriptionRepository, (String)"signalSubscriptionRepository");
        Intrinsics.checkNotNullParameter((Object)processInstanceRepository, (String)"processInstanceRepository");
        Intrinsics.checkNotNullParameter((Object)timerRepository, (String)"timerRepository");
        Intrinsics.checkNotNullParameter((Object)clockService, (String)"clockService");
        this.zeebeClient = zeebeClient;
        this.connectorService = connectorService;
        this.processRepository = processRepository;
        this.messageSubscriptionRepository = messageSubscriptionRepository;
        this.messageCorrelationRepository = messageCorrelationRepository;
        this.signalSubscriptionRepository = signalSubscriptionRepository;
        this.processInstanceRepository = processInstanceRepository;
        this.timerRepository = timerRepository;
        this.clockService = clockService;
        this.executor = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(path={"/{processKey}"}, method={RequestMethod.POST})
    public long createInstance(@PathVariable(value="processKey") long processKey, @RequestBody @NotNull String variables) {
        StartEvent noneStartEvent;
        Object v3;
        List startEvents;
        block8: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            BpmnModelInstance bpmnModelInstance;
            Process it;
            Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
            Object object = (Process)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.processRepository), (Object)processKey);
            if (object != null) {
                it = object;
                boolean bl = false;
                byte[] byArray = it.getBpmnXML().getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                v1 = Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(byArray));
            } else {
                v1 = bpmnModelInstance = null;
            }
            if (bpmnModelInstance == null) {
                throw new RuntimeException("No process found with key '" + processKey + "'");
            }
            BpmnModelInstance process = bpmnModelInstance;
            Collection collection = process.getModelElementsByType(StartEvent.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"process.getModelElements\u2026e(StartEvent::class.java)");
            object = collection;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                StartEvent it2 = (StartEvent)element$iv$iv;
                boolean bl = false;
                if (!(it2.getScope() instanceof io.camunda.zeebe.model.bpmn.instance.Process)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            startEvents = (List)destination$iv$iv;
            if (startEvents.isEmpty()) {
                throw new RuntimeException("No start event found.");
            }
            Iterable iterable = startEvents;
            for (Object $i$f$filterTo2 : iterable) {
                StartEvent it3 = (StartEvent)$i$f$filterTo2;
                boolean bl = false;
                if (!it3.getEventDefinitions().isEmpty()) continue;
                v3 = $i$f$filterTo2;
                break block8;
            }
            v3 = null;
        }
        StartEvent startEvent = noneStartEvent = (StartEvent)v3;
        if (startEvent == null) {
            if (startEvents.size() > 1) {
                throw new RuntimeException("More than one start event found but none of them is a none start event.");
            }
            Object object = CollectionsKt.first((List)startEvents);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"startEvents.first()");
            return this.createProcessInstanceWithStartEvent(processKey, (StartEvent)object, variables);
        }
        StartEvent it = startEvent;
        boolean bl = false;
        return this.createProcessInstanceWithNoneStartEvent(processKey, variables);
    }

    private long createProcessInstanceWithNoneStartEvent(long processKey, String variables) {
        return ((ProcessInstanceEvent)this.zeebeClient.newCreateInstanceCommand().processDefinitionKey(processKey).variables(variables).send().join()).getProcessInstanceKey();
    }

    private long createProcessInstanceWithStartEvent(long processKey, StartEvent startEvent, String variables) {
        boolean bl;
        block14: {
            boolean bl2;
            EventDefinition it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block13: {
                boolean bl3;
                block12: {
                    Collection collection = startEvent.getEventDefinitions();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"startEvent.eventDefinitions");
                    $this$any$iv = collection;
                    $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (EventDefinition)element$iv;
                            boolean bl4 = false;
                            if (!(it instanceof MessageEventDefinition)) continue;
                            bl3 = true;
                            break block12;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return this.createProcessInstanceWithMessageStartEvent(processKey, variables);
                }
                Collection collection = startEvent.getEventDefinitions();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"startEvent.eventDefinitions");
                $this$any$iv = collection;
                $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (EventDefinition)element$iv;
                        boolean bl5 = false;
                        if (!(it instanceof TimerEventDefinition)) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return this.createProcessInstanceWithTimerStartEvent(processKey);
            }
            Collection collection = startEvent.getEventDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"startEvent.eventDefinitions");
            $this$any$iv = collection;
            $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (EventDefinition)element$iv;
                    boolean bl6 = false;
                    if (!(it instanceof SignalEventDefinition)) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            return this.createProcessInstanceWithSignalStartEvent(processKey, variables);
        }
        Collection collection = startEvent.getEventDefinitions();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"startEvent.eventDefinitions");
        String type = ((EventDefinition)CollectionsKt.first((Iterable)collection)).getElementType().getTypeName();
        throw new RuntimeException("Can't start process instance with start event of type '" + type + "'");
    }

    private long createProcessInstanceWithMessageStartEvent(long processKey, String variables) {
        MessageSubscription messageSubscription = (MessageSubscription)CollectionsKt.firstOrNull((List)this.messageSubscriptionRepository.findByProcessDefinitionKeyAndElementInstanceKeyIsNull(processKey));
        if (messageSubscription == null) {
            throw new RuntimeException("No message subscription found for process '" + processKey + "'");
        }
        MessageSubscription messageSubscription2 = messageSubscription;
        long messageKey = ((PublishMessageResponse)this.zeebeClient.newPublishMessageCommand().messageName(messageSubscription2.getMessageName()).correlationKey("").variables(variables).timeToLive(Duration.ZERO).send().join()).getMessageKey();
        Long l = this.executor.submit(() -> ProcessesResource.createProcessInstanceWithMessageStartEvent$lambda$7(this, processKey, messageKey)).get();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"executor.submit(Callable\u2026       )\n        }).get()");
        return ((Number)l).longValue();
    }

    /*
     * WARNING - void declaration
     */
    private long getProcessInstanceKeyForMessage(long processKey, long messageKey) {
        long processInstanceKey = -1L;
        while (processInstanceKey < 0L) {
            long l;
            Object v1;
            block4: {
                void $this$firstOrNull$iv;
                Iterable iterable = this.messageCorrelationRepository.findByMessageKey(messageKey);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MessageCorrelation it = (MessageCorrelation)element$iv;
                    boolean bl = false;
                    Long l2 = it.getProcessDefinitionKey();
                    long l3 = processKey;
                    if (!(l2 != null && l2 == l3)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            MessageCorrelation messageCorrelation = v1;
            if (messageCorrelation != null) {
                l = messageCorrelation.getProcessInstanceKey();
            } else {
                ProcessesResource $this$getProcessInstanceKeyForMessage_u24lambda_u249 = this;
                boolean bl = false;
                Thread.sleep(ProcessesResourceKt.access$getRETRY_INTERVAL$p().toMillis());
                l = -1L;
            }
            processInstanceKey = l;
        }
        return processInstanceKey;
    }

    /*
     * WARNING - void declaration
     */
    private long createProcessInstanceWithTimerStartEvent(long processKey) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Iterable iterable = this.timerRepository.findByProcessDefinitionKeyAndElementInstanceKeyIsNull(processKey);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Timer it = (Timer)element$iv;
                boolean bl = false;
                if (!(it.getState() == TimerState.CREATED)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Timer timer = v0;
        if (timer == null) {
            throw new RuntimeException("No timer found for process '" + processKey + "'");
        }
        Timer timer2 = timer;
        Instant currentTime = this.clockService.getCurrentTime();
        Duration duration = Duration.between(currentTime, Instant.ofEpochMilli(timer2.getDueDate()));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"duration");
        this.clockService.increaseTime(duration);
        Long l = this.executor.submit(() -> ProcessesResource.createProcessInstanceWithTimerStartEvent$lambda$11(this, timer2)).get();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"executor.submit(Callable\u2026       )\n        }).get()");
        return ((Number)l).longValue();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private long getProcessInstanceForTimer(long timerKey) {
        processInstanceKey = -1L;
        while (processInstanceKey < 0L) {
            var5_3 = (Timer)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.timerRepository), (Object)timerKey);
            if (var5_3 == null) ** GOTO lbl-1000
            var7_5 = var5_3;
            it = var7_5;
            $i$a$-takeIf-ProcessesResource$getProcessInstanceForTimer$1 = false;
            v0 /* !! */  = var6_4 = it.getState() == TimerState.TRIGGERED != false ? var7_5 : null;
            if (var6_4 != null && (var7_5 = var6_4.getProcessInstanceKey()) != null) {
                v1 = var7_5.longValue();
            } else lbl-1000:
            // 2 sources

            {
                $this$getProcessInstanceForTimer_u24lambda_u2413 = this;
                $i$a$-run-ProcessesResource$getProcessInstanceForTimer$2 = false;
                Thread.sleep(ProcessesResourceKt.access$getRETRY_INTERVAL$p().toMillis());
                v1 = -1L;
            }
            processInstanceKey = v1;
        }
        return processInstanceKey;
    }

    private long createProcessInstanceWithSignalStartEvent(long processKey, String variables) {
        SignalSubscription signalSubscription = (SignalSubscription)CollectionsKt.firstOrNull((List)this.signalSubscriptionRepository.findByProcessDefinitionKey(processKey));
        if (signalSubscription == null) {
            throw new RuntimeException("No signal subscription found for process '" + processKey + "'");
        }
        SignalSubscription signalSubscription2 = signalSubscription;
        long signalKey = ((BroadcastSignalResponse)this.zeebeClient.newBroadcastSignalCommand().signalName(signalSubscription2.getSignalName()).variables(variables).send().join()).getKey();
        Long l = this.executor.submit(() -> ProcessesResource.createProcessInstanceWithSignalStartEvent$lambda$14(this, processKey, signalKey)).get();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"executor.submit(Callable\u2026       )\n        }).get()");
        return ((Number)l).longValue();
    }

    /*
     * WARNING - void declaration
     */
    private long getProcessInstanceKeyForSignal(long processKey, long signalKey) {
        long processInstanceKey = -1L;
        while (processInstanceKey < 0L) {
            long l;
            Object v2;
            block4: {
                void $this$firstOrNull$iv;
                Object object = new ProcessInstanceState[]{ProcessInstanceState.ACTIVATED, ProcessInstanceState.COMPLETED, ProcessInstanceState.TERMINATED};
                List list = CollectionsKt.listOf((Object[])object);
                PageRequest pageRequest = PageRequest.of((int)0, (int)1000);
                Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(0, 1000)");
                object = this.processInstanceRepository.findByProcessDefinitionKeyAndStateIn(processKey, list, (Pageable)pageRequest);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ProcessInstance it = (ProcessInstance)element$iv;
                    boolean bl = false;
                    if (!(it.getKey() > signalKey)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            ProcessInstance processInstance = v2;
            if (processInstance != null) {
                l = processInstance.getKey();
            } else {
                ProcessesResource $this$getProcessInstanceKeyForSignal_u24lambda_u2416 = this;
                boolean bl = false;
                Thread.sleep(ProcessesResourceKt.access$getRETRY_INTERVAL$p().toMillis());
                l = -1L;
            }
            processInstanceKey = l;
        }
        return processInstanceKey;
    }

    @RequestMapping(path={"/{processKey}/missing-connector-secrets"}, method={RequestMethod.GET})
    @NotNull
    public MissingConnectorSecretsDto findMissingConnectorSecrets(@PathVariable(value="processKey") long processKey) {
        return new MissingConnectorSecretsDto(this.connectorService.getMissingConnectorSecrets(processKey));
    }

    private static final Long createProcessInstanceWithMessageStartEvent$lambda$7(ProcessesResource this$0, long $processKey, long $messageKey) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getProcessInstanceKeyForMessage($processKey, $messageKey);
    }

    private static final Long createProcessInstanceWithTimerStartEvent$lambda$11(ProcessesResource this$0, Timer $timer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$timer, (String)"$timer");
        return this$0.getProcessInstanceForTimer($timer.getKey());
    }

    private static final Long createProcessInstanceWithSignalStartEvent$lambda$14(ProcessesResource this$0, long $processKey, long $signalKey) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getProcessInstanceKeyForSignal($processKey, $signalKey);
    }
}

