/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play;

import io.camunda.connector.runtime.OutboundConnectorsAutoConfiguration;
import io.zeebe.zeeqs.importer.hazelcast.HazelcastImporter;
import io.zeebe.zeeqs.importer.hazelcast.HazelcastProperties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.zeebe.play.zeebe.ZeebeService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.data.web.config.EnableSpringDataWebSupport;

@SpringBootApplication(exclude={OutboundConnectorsAutoConfiguration.class})
@EnableSpringDataWebSupport
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0013H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/camunda/community/zeebe/play/ZeebePlayApplication;", "", "hazelcastProperties", "Lio/zeebe/zeeqs/importer/hazelcast/HazelcastProperties;", "hazelcastImporter", "Lio/zeebe/zeeqs/importer/hazelcast/HazelcastImporter;", "zeebeService", "Lorg/camunda/community/zeebe/play/zeebe/ZeebeService;", "(Lio/zeebe/zeeqs/importer/hazelcast/HazelcastProperties;Lio/zeebe/zeeqs/importer/hazelcast/HazelcastImporter;Lorg/camunda/community/zeebe/play/zeebe/ZeebeService;)V", "getHazelcastImporter", "()Lio/zeebe/zeeqs/importer/hazelcast/HazelcastImporter;", "getHazelcastProperties", "()Lio/zeebe/zeeqs/importer/hazelcast/HazelcastProperties;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getZeebeService", "()Lorg/camunda/community/zeebe/play/zeebe/ZeebeService;", "init", "", "stop", "zeebe-play"})
public class ZeebePlayApplication {
    @NotNull
    private final HazelcastProperties hazelcastProperties;
    @NotNull
    private final HazelcastImporter hazelcastImporter;
    @NotNull
    private final ZeebeService zeebeService;
    private final Logger logger;

    public ZeebePlayApplication(@NotNull HazelcastProperties hazelcastProperties, @NotNull HazelcastImporter hazelcastImporter, @NotNull ZeebeService zeebeService) {
        Intrinsics.checkNotNullParameter((Object)hazelcastProperties, (String)"hazelcastProperties");
        Intrinsics.checkNotNullParameter((Object)hazelcastImporter, (String)"hazelcastImporter");
        Intrinsics.checkNotNullParameter((Object)zeebeService, (String)"zeebeService");
        this.hazelcastProperties = hazelcastProperties;
        this.hazelcastImporter = hazelcastImporter;
        this.zeebeService = zeebeService;
        this.logger = LoggerFactory.getLogger(ZeebePlayApplication.class);
    }

    @NotNull
    public HazelcastProperties getHazelcastProperties() {
        return this.hazelcastProperties;
    }

    @NotNull
    public HazelcastImporter getHazelcastImporter() {
        return this.hazelcastImporter;
    }

    @NotNull
    public ZeebeService getZeebeService() {
        return this.zeebeService;
    }

    @PostConstruct
    public void init() {
        this.getZeebeService().start();
        this.logger.info("Connecting to Hazelcast: '" + this.getHazelcastProperties() + "'");
        this.getHazelcastImporter().start(this.getHazelcastProperties());
        this.logger.info("Connected to Hazelcast!");
    }

    @PreDestroy
    public void stop() {
        this.getZeebeService().stop();
    }
}

