/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.connectors;

import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.core.ConnectorHelper;
import io.camunda.connector.runtime.core.outbound.ConnectorJobHandler;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.zeebe.play.connectors.ConnectorProperties;
import org.camunda.community.zeebe.play.connectors.ConnectorSecret;
import org.camunda.community.zeebe.play.connectors.ConnectorSecretRepository;
import org.camunda.community.zeebe.play.connectors.ConnectorService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@EnableJpaRepositories
@EntityScan
@EnableConfigurationProperties(value={ConnectorProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u0011H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/camunda/community/zeebe/play/connectors/ConnectorsConfig;", "", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "secretProvider", "Lio/camunda/connector/api/secret/SecretProvider;", "connectorProperties", "Lorg/camunda/community/zeebe/play/connectors/ConnectorProperties;", "connectorSecretRepository", "Lorg/camunda/community/zeebe/play/connectors/ConnectorSecretRepository;", "connectorService", "Lorg/camunda/community/zeebe/play/connectors/ConnectorService;", "(Lio/camunda/zeebe/client/ZeebeClient;Lio/camunda/connector/api/secret/SecretProvider;Lorg/camunda/community/zeebe/play/connectors/ConnectorProperties;Lorg/camunda/community/zeebe/play/connectors/ConnectorSecretRepository;Lorg/camunda/community/zeebe/play/connectors/ConnectorService;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "startConnectors", "", "storeConnectorSecrets", "zeebe-play"})
@SourceDebugExtension(value={"SMAP\nConnectorsConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectorsConfig.kt\norg/camunda/community/zeebe/play/connectors/ConnectorsConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1855#2,2:64\n1855#2,2:66\n*S KotlinDebug\n*F\n+ 1 ConnectorsConfig.kt\norg/camunda/community/zeebe/play/connectors/ConnectorsConfig\n*L\n34#1:64,2\n54#1:66,2\n*E\n"})
public class ConnectorsConfig {
    @NotNull
    private final ZeebeClient zeebeClient;
    @NotNull
    private final SecretProvider secretProvider;
    @NotNull
    private final ConnectorProperties connectorProperties;
    @NotNull
    private final ConnectorSecretRepository connectorSecretRepository;
    @NotNull
    private final ConnectorService connectorService;
    private final Logger logger;

    public ConnectorsConfig(@NotNull ZeebeClient zeebeClient, @NotNull SecretProvider secretProvider, @NotNull ConnectorProperties connectorProperties, @NotNull ConnectorSecretRepository connectorSecretRepository, @NotNull ConnectorService connectorService) {
        Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
        Intrinsics.checkNotNullParameter((Object)secretProvider, (String)"secretProvider");
        Intrinsics.checkNotNullParameter((Object)connectorProperties, (String)"connectorProperties");
        Intrinsics.checkNotNullParameter((Object)connectorSecretRepository, (String)"connectorSecretRepository");
        Intrinsics.checkNotNullParameter((Object)connectorService, (String)"connectorService");
        this.zeebeClient = zeebeClient;
        this.secretProvider = secretProvider;
        this.connectorProperties = connectorProperties;
        this.connectorSecretRepository = connectorSecretRepository;
        this.connectorService = connectorService;
        this.logger = LoggerFactory.getLogger(ConnectorsConfig.class);
    }

    @PostConstruct
    public void startConnectors() {
        if (this.connectorProperties.getMode() == ConnectorProperties.ConnectorsMode.ACTIVE) {
            Iterable $this$forEach$iv = this.connectorService.findAvailableConnectors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OutboundConnectorConfiguration connectorConfig = (OutboundConnectorConfiguration)element$iv;
                boolean bl = false;
                OutboundConnectorFunction connector = (OutboundConnectorFunction)ConnectorHelper.instantiateConnector((Class)connectorConfig.getConnectorClass());
                ConnectorJobHandler jobHandler = new ConnectorJobHandler(connector, this.secretProvider);
                JobWorkerBuilderStep1.JobWorkerBuilderStep3 jobWorkerBuilderStep3 = this.zeebeClient.newWorker().jobType(connectorConfig.getType()).handler((JobHandler)jobHandler).name(connectorConfig.getName());
                String[] stringArray = connectorConfig.getInputVariables();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"connectorConfig.inputVariables");
                jobWorkerBuilderStep3.fetchVariables(ArraysKt.toList((Object[])stringArray)).open();
                this.logger.info("Start Zeebe connector. [name: '" + connectorConfig.getName() + "', type: '" + connectorConfig.getType() + "']");
            }
        }
    }

    @PostConstruct
    public void storeConnectorSecrets() {
        Iterable $this$forEach$iv = this.connectorProperties.getSecrets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConnectorProperties.ConnectorSecretProperty it = (ConnectorProperties.ConnectorSecretProperty)element$iv;
            boolean bl = false;
            ConnectorSecret secret = new ConnectorSecret(it.getName(), it.getValue());
            this.connectorSecretRepository.save((Object)secret);
        }
    }
}

