/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.rest;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.dmn.DecisionEngine;
import io.camunda.zeebe.dmn.DecisionEngineFactory;
import io.camunda.zeebe.dmn.ParsedDecision;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.dmn.impl.ParsedDmnScalaDrg;
import io.zeebe.zeeqs.data.entity.Decision;
import io.zeebe.zeeqs.data.entity.DecisionEvaluation;
import io.zeebe.zeeqs.data.entity.DecisionRequirements;
import io.zeebe.zeeqs.data.repository.DecisionEvaluationRepository;
import io.zeebe.zeeqs.data.repository.DecisionRepository;
import io.zeebe.zeeqs.data.repository.DecisionRequirementsRepository;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.camunda.community.zeebe.play.rest.DecisionsResource;
import org.camunda.community.zeebe.play.rest.DecisionsResourceKt;
import org.camunda.community.zeebe.play.services.ZeebeClockService;
import org.camunda.dmn.parser.FeelExpression;
import org.camunda.dmn.parser.ParsedDecisionLogic;
import org.camunda.dmn.parser.ParsedDecisionTable;
import org.camunda.dmn.parser.ParsedExpression;
import org.camunda.dmn.parser.ParsedInput;
import org.camunda.feel.syntaxtree.Exp;
import org.camunda.feel.syntaxtree.PathExpression;
import org.camunda.feel.syntaxtree.Ref;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import scala.collection.Iterable;
import scala.jdk.javaapi.CollectionConverters;

@RestController
@RequestMapping(value={"/rest/decisions"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002)*B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0012\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0014\u001a\u00020\u0013H\u0017J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0012J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0012J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$2\u0006\u0010%\u001a\u00020&H\u0012J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$2\u0006\u0010'\u001a\u00020(H\u0012R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/camunda/community/zeebe/play/rest/DecisionsResource;", "", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "zeebeClockService", "Lorg/camunda/community/zeebe/play/services/ZeebeClockService;", "decisionEvaluationRepository", "Lio/zeebe/zeeqs/data/repository/DecisionEvaluationRepository;", "decisionRepository", "Lio/zeebe/zeeqs/data/repository/DecisionRepository;", "decisionRequirementsRepository", "Lio/zeebe/zeeqs/data/repository/DecisionRequirementsRepository;", "(Lio/camunda/zeebe/client/ZeebeClient;Lorg/camunda/community/zeebe/play/services/ZeebeClockService;Lio/zeebe/zeeqs/data/repository/DecisionEvaluationRepository;Lio/zeebe/zeeqs/data/repository/DecisionRepository;Lio/zeebe/zeeqs/data/repository/DecisionRequirementsRepository;)V", "decisionEngine", "Lio/camunda/zeebe/dmn/DecisionEngine;", "kotlin.jvm.PlatformType", "executor", "Ljava/util/concurrent/ExecutorService;", "evaluateDecision", "", "decisionKey", "variables", "", "getDecisionEvaluationKey", "commandTime", "Ljava/time/Instant;", "getDecisionInputs", "Lorg/camunda/community/zeebe/play/rest/DecisionsResource$DecisionInputsDto;", "getInputsOfDecision", "", "decision", "Lorg/camunda/dmn/parser/ParsedDecision;", "getInputsOfDecisionLogic", "decisionLogic", "Lorg/camunda/dmn/parser/ParsedDecisionLogic;", "getVariable", "", "input", "Lorg/camunda/dmn/parser/ParsedInput;", "exp", "Lorg/camunda/feel/syntaxtree/Exp;", "DecisionInputDto", "DecisionInputsDto", "zeebe-play"})
@SourceDebugExtension(value={"SMAP\nDecisionsResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecisionsResource.kt\norg/camunda/community/zeebe/play/rest/DecisionsResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n288#2,2:143\n1549#2:145\n1620#2,3:146\n819#2:149\n847#2,2:150\n1549#2:152\n1620#2,3:153\n1360#2:156\n1446#2,5:157\n1360#2:162\n1446#2,5:163\n*S KotlinDebug\n*F\n+ 1 DecisionsResource.kt\norg/camunda/community/zeebe/play/rest/DecisionsResource\n*L\n69#1:143,2\n98#1:145\n98#1:146,3\n99#1:149\n99#1:150,2\n102#1:152\n102#1:153,3\n110#1:156\n110#1:157,5\n116#1:162\n116#1:163,5\n*E\n"})
public class DecisionsResource {
    @NotNull
    private final ZeebeClient zeebeClient;
    @NotNull
    private final ZeebeClockService zeebeClockService;
    @NotNull
    private final DecisionEvaluationRepository decisionEvaluationRepository;
    @NotNull
    private final DecisionRepository decisionRepository;
    @NotNull
    private final DecisionRequirementsRepository decisionRequirementsRepository;
    private final ExecutorService executor;
    private final DecisionEngine decisionEngine;

    public DecisionsResource(@NotNull ZeebeClient zeebeClient, @NotNull ZeebeClockService zeebeClockService, @NotNull DecisionEvaluationRepository decisionEvaluationRepository, @NotNull DecisionRepository decisionRepository, @NotNull DecisionRequirementsRepository decisionRequirementsRepository) {
        Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
        Intrinsics.checkNotNullParameter((Object)zeebeClockService, (String)"zeebeClockService");
        Intrinsics.checkNotNullParameter((Object)decisionEvaluationRepository, (String)"decisionEvaluationRepository");
        Intrinsics.checkNotNullParameter((Object)decisionRepository, (String)"decisionRepository");
        Intrinsics.checkNotNullParameter((Object)decisionRequirementsRepository, (String)"decisionRequirementsRepository");
        this.zeebeClient = zeebeClient;
        this.zeebeClockService = zeebeClockService;
        this.decisionEvaluationRepository = decisionEvaluationRepository;
        this.decisionRepository = decisionRepository;
        this.decisionRequirementsRepository = decisionRequirementsRepository;
        this.executor = Executors.newSingleThreadExecutor();
        this.decisionEngine = DecisionEngineFactory.createDecisionEngine();
    }

    @RequestMapping(path={"/{decisionKey}"}, method={RequestMethod.POST})
    public long evaluateDecision(@PathVariable(value="decisionKey") long decisionKey, @RequestBody @NotNull String variables) {
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Instant now = this.zeebeClockService.getCurrentTime();
        this.zeebeClient.newEvaluateDecisionCommand().decisionKey(decisionKey).variables(variables).send().join();
        Long l = this.executor.submit(() -> DecisionsResource.evaluateDecision$lambda$0(this, decisionKey, now)).get();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"executor.submit(Callable\u2026       )\n        }).get()");
        return ((Number)l).longValue();
    }

    /*
     * WARNING - void declaration
     */
    private long getDecisionEvaluationKey(long decisionKey, Instant commandTime) {
        long decisionEvaluationKey = -1L;
        while (decisionEvaluationKey < 0L) {
            long l;
            Object v1;
            block4: {
                void $this$firstOrNull$iv;
                PageRequest pageRequest = PageRequest.of((int)0, (int)100);
                Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(0, 100)");
                java.lang.Iterable iterable = this.decisionEvaluationRepository.findAllByDecisionKey(decisionKey, (Pageable)pageRequest);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DecisionEvaluation it = (DecisionEvaluation)element$iv;
                    boolean bl = false;
                    if (!(it.getEvaluationTime() >= commandTime.toEpochMilli())) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            DecisionEvaluation decisionEvaluation = v1;
            if (decisionEvaluation != null) {
                l = decisionEvaluation.getKey();
            } else {
                DecisionsResource $this$getDecisionEvaluationKey_u24lambda_u242 = this;
                boolean bl = false;
                Thread.sleep(DecisionsResourceKt.access$getRETRY_INTERVAL$p().toMillis());
                l = -1L;
            }
            decisionEvaluationKey = l;
        }
        return decisionEvaluationKey;
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(path={"/{decisionKey}/inputs"}, method={RequestMethod.GET})
    @NotNull
    public DecisionInputsDto getDecisionInputs(@PathVariable(value="decisionKey") long decisionKey) {
        void $this$mapTo$iv$iv;
        java.lang.Iterable $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Decision decision = (Decision)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.decisionRepository), (Object)decisionKey);
        if (decision == null) {
            throw new RuntimeException("No decision found for key '" + decisionKey + "'.");
        }
        Decision decision2 = decision;
        DecisionRequirements decisionRequirements = (DecisionRequirements)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.decisionRequirementsRepository), (Object)decision2.getDecisionRequirementsKey());
        if (decisionRequirements == null) {
            throw new RuntimeException("No decision requirements found for decision with key '" + decisionKey + "'.");
        }
        DecisionRequirements decisionRequirements2 = decisionRequirements;
        String string = decisionRequirements2.getDmnXML();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        ByteArrayInputStream dmnStream = new ByteArrayInputStream(byArray);
        ParsedDecisionRequirementsGraph parseDrg = this.decisionEngine.parse((InputStream)dmnStream);
        Set variableNames = parseDrg instanceof ParsedDmnScalaDrg ? (Set)((ParsedDmnScalaDrg)parseDrg).getParsedDmn().decisionsById().get((Object)decision2.getDecisionId()).map(arg_0 -> DecisionsResource.getDecisionInputs$lambda$3(this, arg_0)).getOrElse(DecisionsResource::getDecisionInputs$lambda$4) : SetsKt.emptySet();
        Collection collection = parseDrg.getDecisions();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"parseDrg.decisions");
        java.lang.Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        java.lang.Iterable iterable = $this$map$iv;
        java.lang.Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((java.lang.Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ParsedDecision parsedDecision = (ParsedDecision)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getId());
        }
        List decisionIds = (List)destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)variableNames, (String)"variableNames");
        java.lang.Iterable $this$filterNot$iv = variableNames;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (decisionIds.contains(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List inputVariableNames = (List)destination$iv$iv2;
        java.lang.Iterable $this$map$iv2 = inputVariableNames;
        boolean $i$f$map2 = false;
        $this$filterNotTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((java.lang.Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            Collection collection3 = destination$iv$iv2;
            boolean bl = false;
            collection3.add(new DecisionInputDto(it));
        }
        List list = (List)destination$iv$iv2;
        return new DecisionInputsDto(list);
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> getInputsOfDecision(org.camunda.dmn.parser.ParsedDecision decision) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        java.lang.Iterable requiredDecision = CollectionConverters.asJava((Iterable)decision.requiredDecisions());
        Set set = this.getInputsOfDecisionLogic(decision.logic());
        Intrinsics.checkNotNullExpressionValue((Object)requiredDecision, (String)"requiredDecision");
        java.lang.Iterable iterable = requiredDecision;
        Set set2 = set;
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            org.camunda.dmn.parser.ParsedDecision it = (org.camunda.dmn.parser.ParsedDecision)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            java.lang.Iterable list$iv$iv = this.getInputsOfDecision(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (java.lang.Iterable)list$iv$iv);
        }
        return SetsKt.plus((Set)set2, (java.lang.Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> getInputsOfDecisionLogic(ParsedDecisionLogic decisionLogic) {
        Set set;
        if (decisionLogic instanceof ParsedDecisionTable) {
            void $this$flatMapTo$iv$iv;
            java.lang.Iterable iterable = CollectionConverters.asJava((Iterable)((ParsedDecisionTable)decisionLogic).inputs());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"asJava(decisionLogic.inputs())");
            java.lang.Iterable $this$flatMap$iv = iterable;
            boolean $i$f$flatMap = false;
            java.lang.Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ParsedInput it = (ParsedInput)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                java.lang.Iterable list$iv$iv = this.getVariable(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (java.lang.Iterable)list$iv$iv);
            }
            set = CollectionsKt.toSet((java.lang.Iterable)((List)destination$iv$iv));
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private List<String> getVariable(ParsedInput input) {
        List list;
        ParsedExpression inputExp = input.expression();
        if (inputExp instanceof FeelExpression) {
            Exp exp = ((FeelExpression)inputExp).expression().expression();
            Intrinsics.checkNotNullExpressionValue((Object)exp, (String)"inputExp.expression().expression()");
            list = this.getVariable(exp);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private List<String> getVariable(Exp exp) {
        List list;
        Exp exp2 = exp;
        if (exp2 instanceof Ref) {
            list = CollectionsKt.listOf((Object)((Ref)exp).names().head());
        } else if (exp2 instanceof PathExpression) {
            Exp exp3 = ((PathExpression)exp).path();
            Intrinsics.checkNotNullExpressionValue((Object)exp3, (String)"exp.path()");
            list = this.getVariable(exp3);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Long evaluateDecision$lambda$0(DecisionsResource this$0, long $decisionKey, Instant $now) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$now, (String)"$now");
        return this$0.getDecisionEvaluationKey($decisionKey, $now);
    }

    private static final Set getDecisionInputs$lambda$3(DecisionsResource this$0, org.camunda.dmn.parser.ParsedDecision it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return CollectionsKt.toSet((java.lang.Iterable)this$0.getInputsOfDecision(it));
    }

    private static final Set getDecisionInputs$lambda$4() {
        return SetsKt.emptySet();
    }
}

