/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.rest;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.zeebe.zeeqs.data.entity.Process;
import io.zeebe.zeeqs.data.repository.ProcessRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/demo"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017J\u000f\u0010\t\u001a\u0004\u0018\u00010\bH\u0017\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/camunda/community/zeebe/play/rest/DemoResource;", "", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "processRepository", "Lio/zeebe/zeeqs/data/repository/ProcessRepository;", "(Lio/camunda/zeebe/client/ZeebeClient;Lio/zeebe/zeeqs/data/repository/ProcessRepository;)V", "deployDemoResources", "", "getDemoProcessKey", "()Ljava/lang/Long;", "zeebe-play"})
@SourceDebugExtension(value={"SMAP\nDemoResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DemoResource.kt\norg/camunda/community/zeebe/play/rest/DemoResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n766#2:41\n857#2,2:42\n1549#2:44\n1620#2,3:45\n*S KotlinDebug\n*F\n+ 1 DemoResource.kt\norg/camunda/community/zeebe/play/rest/DemoResource\n*L\n35#1:41\n35#1:42,2\n36#1:44\n36#1:45,3\n*E\n"})
public class DemoResource {
    @NotNull
    private final ZeebeClient zeebeClient;
    @NotNull
    private final ProcessRepository processRepository;

    public DemoResource(@NotNull ZeebeClient zeebeClient, @NotNull ProcessRepository processRepository) {
        Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
        Intrinsics.checkNotNullParameter((Object)processRepository, (String)"processRepository");
        this.zeebeClient = zeebeClient;
        this.processRepository = processRepository;
    }

    @RequestMapping(path={"/"}, method={RequestMethod.POST})
    public long deployDemoResources() {
        DeployResourceCommandStep1.DeployResourceCommandStep2 deployCommand = this.zeebeClient.newDeployResourceCommand().addResourceFromClasspath("demo/solos-transport-process.bpmn").addResourceFromClasspath("demo/is_legal_good.dmn");
        List list = ((DeploymentEvent)deployCommand.send().join()).getProcesses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"deployCommand\n          \u2026()\n            .processes");
        return ((io.camunda.zeebe.client.api.response.Process)CollectionsKt.first((List)list)).getProcessDefinitionKey();
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(path={"/"}, method={RequestMethod.GET})
    @Nullable
    public Long getDemoProcessKey() {
        void $this$mapTo$iv$iv;
        Process it;
        Iterable $this$filterTo$iv$iv;
        Iterable iterable = this.processRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"processRepository.findAll()");
        Iterable $this$filter$iv = iterable;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Process)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getBpmnProcessId(), (Object)"solos-transport-process")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Process)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        return (Long)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }
}

