/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.rest;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.response.Decision;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.zeebe.zeeqs.data.entity.DecisionRequirements;
import io.zeebe.zeeqs.data.entity.Process;
import io.zeebe.zeeqs.data.repository.DecisionRequirementsRepository;
import io.zeebe.zeeqs.data.repository.ProcessRepository;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.camunda.community.zeebe.play.rest.DeploymentsResource;
import org.camunda.community.zeebe.play.rest.DeploymentsResourceKt;
import org.camunda.community.zeebe.play.services.ZeebeClockService;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/deployments"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0003#$%B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0012\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u000e\b\u0001\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0017\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u000e\b\u0001\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0017\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0012J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u001c\u001a\u00020\u0015H\u0012J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0015H\u0012J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u001e2\u0006\u0010!\u001a\u00020\u0015H\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/camunda/community/zeebe/play/rest/DeploymentsResource;", "", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "zeebeClockService", "Lorg/camunda/community/zeebe/play/services/ZeebeClockService;", "processRepository", "Lio/zeebe/zeeqs/data/repository/ProcessRepository;", "decisionRequirementsRepository", "Lio/zeebe/zeeqs/data/repository/DecisionRequirementsRepository;", "(Lio/camunda/zeebe/client/ZeebeClient;Lorg/camunda/community/zeebe/play/services/ZeebeClockService;Lio/zeebe/zeeqs/data/repository/ProcessRepository;Lio/zeebe/zeeqs/data/repository/DecisionRequirementsRepository;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "deploy", "Lio/camunda/zeebe/client/api/response/DeploymentEvent;", "resources", "", "Lorg/springframework/web/multipart/MultipartFile;", "([Lorg/springframework/web/multipart/MultipartFile;)Lio/camunda/zeebe/client/api/response/DeploymentEvent;", "deployResources", "", "([Lorg/springframework/web/multipart/MultipartFile;)J", "deployResourcesWithMetadata", "Lorg/camunda/community/zeebe/play/rest/DeploymentsResource$DeploymentResponse;", "([Lorg/springframework/web/multipart/MultipartFile;)Lorg/camunda/community/zeebe/play/rest/DeploymentsResource$DeploymentResponse;", "findDecisionRequirementsByKey", "Lio/zeebe/zeeqs/data/entity/DecisionRequirements;", "decisionRequirementsKey", "findDecisionRequirementsByKeyAsync", "Ljava/util/concurrent/Future;", "findProcessByKey", "Lio/zeebe/zeeqs/data/entity/Process;", "processKey", "findProcessByKeyAsync", "DeployedDecision", "DeployedProcess", "DeploymentResponse", "zeebe-play"})
@SourceDebugExtension(value={"SMAP\nDeploymentsResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeploymentsResource.kt\norg/camunda/community/zeebe/play/rest/DeploymentsResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1179#2,2:163\n1253#2,4:165\n1179#2,2:169\n1253#2,4:171\n1549#2:175\n1620#2,3:176\n1549#2:179\n1620#2,2:180\n1622#2:183\n1855#2,2:184\n1#3:182\n*S KotlinDebug\n*F\n+ 1 DeploymentsResource.kt\norg/camunda/community/zeebe/play/rest/DeploymentsResource\n*L\n48#1:163,2\n48#1:165,4\n51#1:169,2\n51#1:171,4\n57#1:175\n57#1:176,3\n72#1:179\n72#1:180,2\n72#1:183\n103#1:184,2\n*E\n"})
public class DeploymentsResource {
    @NotNull
    private final ZeebeClient zeebeClient;
    @NotNull
    private final ZeebeClockService zeebeClockService;
    @NotNull
    private final ProcessRepository processRepository;
    @NotNull
    private final DecisionRequirementsRepository decisionRequirementsRepository;
    private final ExecutorService executor;

    public DeploymentsResource(@NotNull ZeebeClient zeebeClient, @NotNull ZeebeClockService zeebeClockService, @NotNull ProcessRepository processRepository, @NotNull DecisionRequirementsRepository decisionRequirementsRepository) {
        Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
        Intrinsics.checkNotNullParameter((Object)zeebeClockService, (String)"zeebeClockService");
        Intrinsics.checkNotNullParameter((Object)processRepository, (String)"processRepository");
        Intrinsics.checkNotNullParameter((Object)decisionRequirementsRepository, (String)"decisionRequirementsRepository");
        this.zeebeClient = zeebeClient;
        this.zeebeClockService = zeebeClockService;
        this.processRepository = processRepository;
        this.decisionRequirementsRepository = decisionRequirementsRepository;
        this.executor = Executors.newSingleThreadExecutor();
    }

    @RequestMapping(path={"/"}, method={RequestMethod.POST})
    public long deployResources(@RequestParam(value="resources") @NotNull MultipartFile[] resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        return this.deploy(resources).getKey();
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(path={"/deploy"}, method={RequestMethod.POST})
    @NotNull
    public DeploymentResponse deployResourcesWithMetadata(@RequestParam(value="resources") @NotNull MultipartFile[] resources) {
        Object object;
        boolean bl;
        long l;
        String string;
        String string2;
        Decision process;
        Object object2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$associateTo$iv$iv;
        Object it;
        void $this$associateTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Instant timeBeforeDeploy = this.zeebeClockService.getCurrentTime();
        DeploymentEvent deployment = this.deploy(resources);
        List list = deployment.getProcesses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"deployment.processes");
        Iterable $this$associate$iv = list;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv2) {
            Map map = destination$iv$iv;
            it = (io.camunda.zeebe.client.api.response.Process)element$iv$iv;
            boolean bl2 = false;
            it = TuplesKt.to((Object)it.getProcessDefinitionKey(), (Object)this.findProcessByKeyAsync(it.getProcessDefinitionKey()));
            map.put(it.getFirst(), it.getSecond());
        }
        Map deployedProcesses = destination$iv$iv;
        List list2 = deployment.getDecisions();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"deployment.decisions");
        Iterable $this$associate$iv2 = list2;
        boolean $i$f$associate2 = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            it = destination$iv$iv2;
            Decision it2 = (Decision)element$iv$iv;
            boolean bl3 = false;
            it2 = TuplesKt.to((Object)it2.getDecisionRequirementsKey(), (Object)this.findDecisionRequirementsByKeyAsync(it2.getDecisionRequirementsKey()));
            it.put(it2.getFirst(), it2.getSecond());
        }
        Map deployedDecisionRequirements = destination$iv$iv2;
        long l2 = deployment.getKey();
        List list3 = deployment.getProcesses();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"deployment.processes");
        $this$associate$iv2 = list3;
        long l3 = l2;
        boolean $i$f$map = false;
        void capacity$iv22 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            boolean bl4;
            Object element$iv$iv;
            element$iv$iv = (io.camunda.zeebe.client.api.response.Process)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl5 = false;
            long l4 = process.getProcessDefinitionKey();
            String string3 = process.getBpmnProcessId();
            String string4 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"process.bpmnProcessId");
            String string5 = process.getResourceName();
            String string6 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"process.resourceName");
            Future it2 = (Future)deployedProcesses.get(process.getProcessDefinitionKey());
            if (it2 != null) {
                void it3;
                Future bl3 = it2;
                string2 = string6;
                string = string4;
                l = l4;
                boolean bl6 = false;
                bl = ((Process)it3.get(10L, TimeUnit.SECONDS)).getDeployTime() < timeBeforeDeploy.toEpochMilli();
                l4 = l;
                string4 = string;
                string6 = string2;
                bl4 = bl;
            } else {
                bl4 = false;
            }
            boolean bl7 = bl4;
            String string7 = string6;
            String string8 = string4;
            long l5 = l4;
            object2.add(new DeployedProcess(l5, string8, string7, bl7));
        }
        object2 = (List)destination$iv$iv;
        List list4 = deployment.getDecisions();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"deployment.decisions");
        $this$map$iv = list4;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            boolean bl8;
            void decision;
            process = (Decision)item$iv$iv;
            object = destination$iv$iv;
            boolean bl9 = false;
            Future future = (Future)deployedDecisionRequirements.get(decision.getDecisionRequirementsKey());
            DecisionRequirements decisionRequirements = future != null ? (DecisionRequirements)future.get(10L, TimeUnit.SECONDS) : null;
            long l6 = decision.getDecisionKey();
            String string9 = decision.getDmnDecisionId();
            String string10 = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"decision.dmnDecisionId");
            Object object3 = decisionRequirements;
            if (object3 == null || (object3 = object3.getResourceName()) == null) {
                object3 = "?";
            }
            if (decisionRequirements != null) {
                DecisionRequirements it3 = decisionRequirements;
                string2 = object3;
                string = string10;
                l = l6;
                boolean bl10 = false;
                bl = it3.getDeployTime() < timeBeforeDeploy.toEpochMilli();
                l6 = l;
                string10 = string;
                object3 = string2;
                bl8 = bl;
            } else {
                bl8 = false;
            }
            boolean bl11 = bl8;
            Object object4 = object3;
            String string11 = string10;
            long l7 = l6;
            object.add(new DeployedDecision(l7, string11, (String)object4, bl11));
        }
        object = (List)destination$iv$iv;
        List list5 = object;
        Object object5 = object2;
        long l8 = l3;
        return new DeploymentResponse(l8, (List)object5, list5);
    }

    /*
     * WARNING - void declaration
     */
    private DeploymentEvent deploy(MultipartFile[] resources) {
        void $this$forEach$iv;
        if (resources.length == 0) {
            throw new RuntimeException("no resources to deploy");
        }
        MultipartFile firstResource = (MultipartFile)ArraysKt.first((Object[])resources);
        DeployResourceCommandStep1.DeployResourceCommandStep2 deployCommand = this.zeebeClient.newDeployResourceCommand().addResourceBytes(firstResource.getBytes(), firstResource.getResource().getFilename());
        Iterable iterable = ArraysKt.drop((Object[])resources, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MultipartFile it = (MultipartFile)element$iv;
            boolean bl = false;
            deployCommand.addResourceBytes(it.getBytes(), it.getResource().getFilename());
        }
        Object object = deployCommand.send().join();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deployCommand\n          \u2026end()\n            .join()");
        return (DeploymentEvent)object;
    }

    private Future<Process> findProcessByKeyAsync(long processKey) {
        Future<Process> future = this.executor.submit(() -> DeploymentsResource.findProcessByKeyAsync$lambda$7(this, processKey));
        Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit(Callable\u2026 = processKey)\n        })");
        return future;
    }

    private Process findProcessByKey(long processKey) {
        Process process = (Process)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.processRepository), (Object)processKey);
        if (process == null) {
            DeploymentsResource $this$findProcessByKey_u24lambda_u248 = this;
            boolean bl = false;
            Thread.sleep(DeploymentsResourceKt.access$getRETRY_INTERVAL$p().toMillis());
            process = $this$findProcessByKey_u24lambda_u248.findProcessByKey(processKey);
        }
        return process;
    }

    private Future<DecisionRequirements> findDecisionRequirementsByKeyAsync(long decisionRequirementsKey) {
        Future<DecisionRequirements> future = this.executor.submit(() -> DeploymentsResource.findDecisionRequirementsByKeyAsync$lambda$9(this, decisionRequirementsKey));
        Intrinsics.checkNotNullExpressionValue(future, (String)"executor.submit(Callable\u2026quirementsKey)\n        })");
        return future;
    }

    private DecisionRequirements findDecisionRequirementsByKey(long decisionRequirementsKey) {
        DecisionRequirements decisionRequirements = (DecisionRequirements)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.decisionRequirementsRepository), (Object)decisionRequirementsKey);
        if (decisionRequirements == null) {
            DeploymentsResource $this$findDecisionRequirementsByKey_u24lambda_u2410 = this;
            boolean bl = false;
            Thread.sleep(DeploymentsResourceKt.access$getRETRY_INTERVAL$p().toMillis());
            decisionRequirements = $this$findDecisionRequirementsByKey_u24lambda_u2410.findDecisionRequirementsByKey(decisionRequirementsKey);
        }
        return decisionRequirements;
    }

    private static final Process findProcessByKeyAsync$lambda$7(DeploymentsResource this$0, long $processKey) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.findProcessByKey($processKey);
    }

    private static final DecisionRequirements findDecisionRequirementsByKeyAsync$lambda$9(DeploymentsResource this$0, long $decisionRequirementsKey) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.findDecisionRequirementsByKey($decisionRequirementsKey);
    }
}

