/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.rest;

import io.camunda.zeebe.client.ZeebeClient;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.zeebe.play.rest.JobsResource;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/jobs"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u001c\u0010\u000b\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\fH\u0017J\u001c\u0010\r\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u000eH\u0017J\u001c\u0010\u000f\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/camunda/community/zeebe/play/rest/JobsResource;", "", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "(Lio/camunda/zeebe/client/ZeebeClient;)V", "complete", "", "jobKey", "", "command", "Lorg/camunda/community/zeebe/play/rest/JobsResource$CompleteJobCommand;", "fail", "Lorg/camunda/community/zeebe/play/rest/JobsResource$FailJobCommand;", "throwError", "Lorg/camunda/community/zeebe/play/rest/JobsResource$ThrowErrorJobCommand;", "updateRetries", "Lorg/camunda/community/zeebe/play/rest/JobsResource$UpdateRetriesJobCommand;", "CompleteJobCommand", "FailJobCommand", "ThrowErrorJobCommand", "UpdateRetriesJobCommand", "zeebe-play"})
public class JobsResource {
    @NotNull
    private final ZeebeClient zeebeClient;

    public JobsResource(@NotNull ZeebeClient zeebeClient) {
        Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
        this.zeebeClient = zeebeClient;
    }

    @RequestMapping(path={"/{jobKey}/complete"}, method={RequestMethod.POST})
    public void complete(@PathVariable(value="jobKey") long jobKey, @RequestBody @NotNull CompleteJobCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.zeebeClient.newCompleteCommand(jobKey).variables(command.getVariables()).send().join();
    }

    @RequestMapping(path={"/{jobKey}/fail"}, method={RequestMethod.POST})
    public void fail(@PathVariable(value="jobKey") long jobKey, @RequestBody @NotNull FailJobCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.zeebeClient.newFailCommand(jobKey).retries(command.getRetries()).errorMessage(command.getErrorMessage()).send().join();
    }

    @RequestMapping(path={"/{jobKey}/throw-error"}, method={RequestMethod.POST})
    public void throwError(@PathVariable(value="jobKey") long jobKey, @RequestBody @NotNull ThrowErrorJobCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.zeebeClient.newThrowErrorCommand(jobKey).errorCode(command.getErrorCode()).errorMessage(command.getErrorMessage()).send().join();
    }

    @RequestMapping(path={"/{jobKey}/update-retries"}, method={RequestMethod.POST})
    public void updateRetries(@PathVariable(value="jobKey") long jobKey, @RequestBody @NotNull UpdateRetriesJobCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.zeebeClient.newUpdateRetriesCommand(jobKey).retries(command.getRetries()).send().join();
    }
}

