/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.rest;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.BrokerInfo;
import io.camunda.zeebe.client.api.response.PartitionBrokerHealth;
import io.camunda.zeebe.client.api.response.PartitionInfo;
import io.camunda.zeebe.client.api.response.Topology;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.camunda.community.zeebe.play.rest.StatusResource;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/status"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0002\n\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\u0006H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/camunda/community/zeebe/play/rest/StatusResource;", "", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "(Lio/camunda/zeebe/client/ZeebeClient;)V", "zeebePlayVersion", "", "getStatus", "Lorg/camunda/community/zeebe/play/rest/StatusResource$StatusDto;", "readZeebePlayVersion", "StatusDto", "ZeebeStatus", "zeebe-play"})
@SourceDebugExtension(value={"SMAP\nStatusResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatusResource.kt\norg/camunda/community/zeebe/play/rest/StatusResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1549#2:72\n1620#2,3:73\n1360#2:76\n1446#2,5:77\n766#2:82\n857#2,2:83\n1549#2:85\n1620#2,3:86\n1789#2,3:89\n1#3:92\n*S KotlinDebug\n*F\n+ 1 StatusResource.kt\norg/camunda/community/zeebe/play/rest/StatusResource\n*L\n25#1:72\n25#1:73,3\n28#1:76\n28#1:77,5\n29#1:82\n29#1:83,2\n30#1:85\n30#1:86,3\n31#1:89,3\n*E\n"})
public class StatusResource {
    @NotNull
    private final ZeebeClient zeebeClient;
    @NotNull
    private final String zeebePlayVersion;

    public StatusResource(@NotNull ZeebeClient zeebeClient) {
        Intrinsics.checkNotNullParameter((Object)zeebeClient, (String)"zeebeClient");
        this.zeebeClient = zeebeClient;
        this.zeebePlayVersion = this.readZeebePlayVersion();
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(method={RequestMethod.GET})
    @NotNull
    public StatusDto getStatus() {
        try {
            void $this$fold$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            BrokerInfo it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Topology topology = (Topology)this.zeebeClient.newTopologyRequest().send().join();
            List list = topology.getBrokers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"topology.brokers");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                BrokerInfo brokerInfo = (BrokerInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getVersion());
            }
            String string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (string == null) {
                string = "?";
            }
            String zeebeVersion = string;
            List list2 = topology.getBrokers();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"topology.brokers");
            $this$map$iv = list2;
            boolean $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (BrokerInfo)element$iv$iv;
                boolean bl = false;
                List list3 = it.getPartitions();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"it.partitions");
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PartitionInfo)element$iv$iv;
                boolean bl = false;
                if (!it.isLeader()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (PartitionInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getHealth());
            }
            $this$map$iv = (List)destination$iv$iv;
            ZeebeStatus initial$iv = ZeebeStatus.HEALTHY;
            boolean $i$f$fold = false;
            ZeebeStatus accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                ZeebeStatus zeebeStatus;
                void health;
                Object item$iv$iv;
                item$iv$iv = (PartitionBrokerHealth)element$iv;
                ZeebeStatus result = accumulator$iv;
                boolean bl = false;
                void v4 = health;
                switch (v4 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v4.ordinal()]) {
                    case 1: {
                        zeebeStatus = result;
                        break;
                    }
                    case 2: {
                        zeebeStatus = ZeebeStatus.UNHEALTHY;
                        break;
                    }
                    case 3: {
                        zeebeStatus = ZeebeStatus.UNHEALTHY;
                        break;
                    }
                    default: {
                        zeebeStatus = ZeebeStatus.UNKNOWN;
                    }
                }
                accumulator$iv = zeebeStatus;
            }
            ZeebeStatus zeebeStatus = accumulator$iv;
            return new StatusDto(this.zeebePlayVersion, zeebeVersion, zeebeStatus);
        }
        catch (Exception e) {
            return new StatusDto(this.zeebePlayVersion, "?", ZeebeStatus.UNHEALTHY);
        }
    }

    private String readZeebePlayVersion() {
        String string;
        URL uRL = this.getClass().getResource("/version.txt");
        if (uRL != null) {
            URL it = uRL;
            boolean bl = false;
            string = new String(TextStreamsKt.readBytes((URL)it), Charsets.UTF_8);
        } else {
            string = "?";
        }
        return string;
    }
}

