/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.rest;

import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.zeebe.play.rest.TimersResource;
import org.camunda.community.zeebe.play.services.ZeebeClockService;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/timers"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/camunda/community/zeebe/play/rest/TimersResource;", "", "clockService", "Lorg/camunda/community/zeebe/play/services/ZeebeClockService;", "(Lorg/camunda/community/zeebe/play/services/ZeebeClockService;)V", "increaseTime", "", "command", "Lorg/camunda/community/zeebe/play/rest/TimersResource$TimeTravelCommand;", "TimeTravelCommand", "zeebe-play"})
public class TimersResource {
    @NotNull
    private final ZeebeClockService clockService;

    public TimersResource(@NotNull ZeebeClockService clockService) {
        Intrinsics.checkNotNullParameter((Object)clockService, (String)"clockService");
        this.clockService = clockService;
    }

    @RequestMapping(method={RequestMethod.POST})
    public long increaseTime(@RequestBody @NotNull TimeTravelCommand command) {
        long newTime;
        block1: {
            String it;
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            newTime = 0L;
            newTime = -1L;
            String string = command.getDuration();
            if (string != null) {
                it = string;
                boolean bl = false;
                Duration duration = Duration.parse(it);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"duration");
                newTime = this.clockService.increaseTime(duration);
            }
            String string2 = command.getDateTime();
            if (string2 == null) break block1;
            it = string2;
            boolean bl = false;
            ZonedDateTime dateTime = ZonedDateTime.parse(it);
            Instant currentTime = this.clockService.getCurrentTime();
            Duration duration = Duration.between(currentTime, dateTime);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"duration");
            newTime = this.clockService.increaseTime(duration);
        }
        return newTime;
    }
}

