/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.play.zeebe;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.camunda.community.zeebe.play.zeebe.RemoteZeebeConfig;
import org.camunda.community.zeebe.play.zeebe.ZeebeService;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"zeebe.engine"}, havingValue="remote")
@EnableConfigurationProperties(value={ZeebeClientConfigurationProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/camunda/community/zeebe/play/zeebe/RemoteZeebeConfig;", "", "()V", "zeebeClockEndpoint", "", "remoteZeebeService", "Lorg/camunda/community/zeebe/play/zeebe/ZeebeService;", "zeebeClient", "Lio/camunda/zeebe/client/ZeebeClient;", "config", "Lio/camunda/zeebe/spring/client/properties/ZeebeClientConfigurationProperties;", "RemoteZeebeService", "zeebe-play"})
public class RemoteZeebeConfig {
    @Value(value="${zeebe.clock.endpoint}")
    private String zeebeClockEndpoint;

    @Bean
    @NotNull
    public ZeebeService remoteZeebeService() {
        String string = this.zeebeClockEndpoint;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"zeebeClockEndpoint");
            string = null;
        }
        return (ZeebeService)new RemoteZeebeService(string);
    }

    @Bean
    @NotNull
    public ZeebeClient zeebeClient(@NotNull ZeebeClientConfigurationProperties config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ZeebeClient zeebeClient = ZeebeClient.newClient((ZeebeClientConfiguration)((ZeebeClientConfiguration)config));
        Intrinsics.checkNotNullExpressionValue((Object)zeebeClient, (String)"newClient(config)");
        return zeebeClient;
    }
}

