/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.zeebe.spec.DirectoryResourceResolver;
import org.camunda.community.zeebe.spec.ResourceResolver;
import org.camunda.community.zeebe.spec.api.Action;
import org.camunda.community.zeebe.spec.api.Instruction;
import org.camunda.community.zeebe.spec.api.SpecTestRunnerContext;
import org.camunda.community.zeebe.spec.api.TestCase;
import org.camunda.community.zeebe.spec.api.TestContext;
import org.camunda.community.zeebe.spec.api.TestOutput;
import org.camunda.community.zeebe.spec.api.TestResult;
import org.camunda.community.zeebe.spec.api.TestSpec;
import org.camunda.community.zeebe.spec.api.TestSpecResult;
import org.camunda.community.zeebe.spec.api.Verification;
import org.camunda.community.zeebe.spec.api.VerificationResult;
import org.camunda.community.zeebe.spec.format.SpecDeserializer;
import org.camunda.community.zeebe.spec.runner.SpecActionExecutor;
import org.camunda.community.zeebe.spec.runner.SpecStateProvider;
import org.camunda.community.zeebe.spec.runner.TestRunnerEnvironment;
import org.camunda.community.zeebe.spec.runner.eze.EzeEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001BY\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020\u00072\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"\u0012\b\u0012\u00060#j\u0002`$0!H\u0002J\u000e\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u000e\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"\u0012\b\u0012\u00060#j\u0002`$01H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/camunda/community/zeebe/spec/SpecRunner;", "", "environment", "Lorg/camunda/community/zeebe/spec/runner/TestRunnerEnvironment;", "beforeEachCallback", "Lkotlin/Function1;", "Lorg/camunda/community/zeebe/spec/api/SpecTestRunnerContext;", "", "afterEachCallback", "resourceResolver", "Lorg/camunda/community/zeebe/spec/ResourceResolver;", "verificationTimeout", "Ljava/time/Duration;", "verificationRetryInterval", "(Lorg/camunda/community/zeebe/spec/runner/TestRunnerEnvironment;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lorg/camunda/community/zeebe/spec/ResourceResolver;Ljava/time/Duration;Ljava/time/Duration;)V", "actionExecutor", "Lorg/camunda/community/zeebe/spec/runner/SpecActionExecutor;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "specDeserializer", "Lorg/camunda/community/zeebe/spec/format/SpecDeserializer;", "stateProvider", "Lorg/camunda/community/zeebe/spec/runner/SpecStateProvider;", "collectTestOutput", "", "Lorg/camunda/community/zeebe/spec/api/TestOutput;", "executeTestCase", "Lorg/camunda/community/zeebe/spec/api/TestResult;", "testcase", "Lorg/camunda/community/zeebe/spec/api/TestCase;", "loadContext", "contexts", "", "", "", "Lorg/camunda/community/zeebe/spec/ProcessInstanceKey;", "runSingleTestCase", "runSpec", "Lorg/camunda/community/zeebe/spec/api/TestSpecResult;", "input", "Ljava/io/InputStream;", "spec", "Lorg/camunda/community/zeebe/spec/api/TestSpec;", "runTestCase", "verifyInstruction", "Lorg/camunda/community/zeebe/spec/api/VerificationResult;", "instruction", "Lorg/camunda/community/zeebe/spec/api/Verification;", "", "zeebe-spec-core"})
@SourceDebugExtension(value={"SMAP\nSpecRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecRunner.kt\norg/camunda/community/zeebe/spec/SpecRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n1549#2:218\n1620#2,3:219\n766#2:222\n857#2,2:223\n1549#2:225\n1620#2,3:226\n1855#2,2:229\n1855#2,2:231\n1559#2:233\n1590#2,4:234\n1549#2:238\n1620#2,3:239\n*S KotlinDebug\n*F\n+ 1 SpecRunner.kt\norg/camunda/community/zeebe/spec/SpecRunner\n*L\n47#1:218\n47#1:219,3\n51#1:222\n51#1:223,2\n77#1:225\n77#1:226,3\n87#1:229,2\n131#1:231,2\n171#1:233\n171#1:234,4\n205#1:238\n205#1:239,3\n*E\n"})
public final class SpecRunner {
    @NotNull
    private final TestRunnerEnvironment environment;
    @NotNull
    private final Function1<SpecTestRunnerContext, Unit> beforeEachCallback;
    @NotNull
    private final Function1<SpecTestRunnerContext, Unit> afterEachCallback;
    @NotNull
    private final ResourceResolver resourceResolver;
    @NotNull
    private final Duration verificationTimeout;
    @NotNull
    private final Duration verificationRetryInterval;
    private final Logger logger;
    @NotNull
    private final SpecDeserializer specDeserializer;
    @NotNull
    private final SpecActionExecutor actionExecutor;
    @NotNull
    private final SpecStateProvider stateProvider;

    public SpecRunner(@NotNull TestRunnerEnvironment environment, @NotNull Function1<? super SpecTestRunnerContext, Unit> beforeEachCallback, @NotNull Function1<? super SpecTestRunnerContext, Unit> afterEachCallback, @NotNull ResourceResolver resourceResolver, @NotNull Duration verificationTimeout, @NotNull Duration verificationRetryInterval) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(beforeEachCallback, (String)"beforeEachCallback");
        Intrinsics.checkNotNullParameter(afterEachCallback, (String)"afterEachCallback");
        Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
        Intrinsics.checkNotNullParameter((Object)verificationTimeout, (String)"verificationTimeout");
        Intrinsics.checkNotNullParameter((Object)verificationRetryInterval, (String)"verificationRetryInterval");
        this.environment = environment;
        this.beforeEachCallback = beforeEachCallback;
        this.afterEachCallback = afterEachCallback;
        this.resourceResolver = resourceResolver;
        this.verificationTimeout = verificationTimeout;
        this.verificationRetryInterval = verificationRetryInterval;
        this.logger = LoggerFactory.getLogger(SpecRunner.class);
        this.specDeserializer = new SpecDeserializer();
        this.actionExecutor = this.environment.getActionExecutor();
        this.stateProvider = this.environment.getStateProvider();
    }

    public /* synthetic */ SpecRunner(TestRunnerEnvironment testRunnerEnvironment, Function1 function1, Function1 function12, ResourceResolver resourceResolver, Duration duration, Duration duration2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            testRunnerEnvironment = new EzeEnvironment(null, 1, null);
        }
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function12 = 2.INSTANCE;
        }
        if ((n & 8) != 0) {
            Path path = Path.of(".", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(\n            \".\"\n        )");
            resourceResolver = new DirectoryResourceResolver(path);
        }
        if ((n & 0x10) != 0) {
            Duration duration3 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(10)");
            duration = duration3;
        }
        if ((n & 0x20) != 0) {
            Duration duration4 = Duration.ofMillis(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofMillis(10)");
            duration2 = duration4;
        }
        this(testRunnerEnvironment, (Function1<? super SpecTestRunnerContext, Unit>)function1, (Function1<? super SpecTestRunnerContext, Unit>)function12, resourceResolver, duration, duration2);
    }

    @NotNull
    public final TestSpecResult runSpec(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.logger.trace("Read the spec");
        TestSpec spec = this.specDeserializer.readSpec(input);
        return this.runSpec(spec);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TestSpecResult runSpec(@NotNull TestSpec spec) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        TestResult it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.logger.debug("Run {} tests", (Object)spec.getTestCases().size());
        Iterable $this$map$iv = spec.getTestCases();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TestCase testCase = (TestCase)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.runTestCase((TestCase)((Object)it)));
        }
        List testResults = (List)destination$iv$iv;
        $this$map$iv = testResults;
        String string = "All tests finished [{}/{} passed]";
        collection = this.logger;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TestResult)element$iv$iv;
            boolean bl = false;
            if (!it.getSuccess()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        collection.debug(string, ((Collection)list).size(), testResults.size());
        return new TestSpecResult(spec, testResults);
    }

    @NotNull
    public final TestResult runSingleTestCase(@NotNull TestCase testcase) {
        Intrinsics.checkNotNullParameter((Object)testcase, (String)"testcase");
        this.logger.debug("Run a single test");
        return this.runTestCase(testcase);
    }

    /*
     * WARNING - void declaration
     */
    private final TestResult runTestCase(TestCase testcase) {
        void $this$mapTo$iv$iv;
        this.logger.debug("Prepare the test [name: '{}']", (Object)testcase.getName());
        this.logger.debug("Create spec test environment");
        this.environment.create();
        this.logger.debug("Invoke before-each callback");
        this.beforeEachCallback.invoke((Object)this.environment.getContext());
        Iterable $this$map$iv = this.resourceResolver.getResources();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        String it = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
        boolean bl = false;
        this.logger.debug("Deploy resource for the test. [name: '{}', resources: {}]", (Object)testcase.getName(), (Object)it);
        Iterable $this$forEach$iv = this.resourceResolver.getResources();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File resource = (File)element$iv;
            boolean bl2 = false;
            String resourceName = resource.getName();
            FileInputStream resourceStream = new FileInputStream(resource);
            Intrinsics.checkNotNullExpressionValue((Object)resourceName, (String)"resourceName");
            this.actionExecutor.deployProcess(resourceName, resourceStream);
        }
        this.logger.debug("Run the test [name: '{}', description: '{}']", (Object)testcase.getName(), (Object)testcase.getDescription());
        TestResult result = this.executeTestCase(testcase);
        Object[] objectArray = new Object[]{testcase.getName(), result.getSuccess(), result.getMessage()};
        this.logger.debug("Test finished [name: '{}', success: '{}', message: '{}']", objectArray);
        this.logger.debug("Invoke after-each callback");
        this.afterEachCallback.invoke((Object)this.environment.getContext());
        this.logger.debug("Close spec test environment");
        this.environment.close();
        return result;
    }

    private final TestResult executeTestCase(TestCase testcase) {
        Map contexts = new LinkedHashMap();
        TestContext testContext2 = new TestContext((Function2<? super String, ? super Long, Unit>)((Function2)new Function2<String, Long, Unit>((Map<String, Long>)contexts){
            final /* synthetic */ Map<String, Long> $contexts;
            {
                this.$contexts = $contexts;
                super(2);
            }

            public final void invoke(@NotNull String alias, long context) {
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                this.$contexts.put(alias, context);
            }
        }), (Function1<? super String, Long>)((Function1)new Function1<String, Long>((Map<String, Long>)contexts){
            final /* synthetic */ Map<String, Long> $contexts;
            {
                this.$contexts = $contexts;
                super(1);
            }

            @NotNull
            public final Long invoke(@Nullable String alias) {
                String string = alias;
                Map<String, Long> map = this.$contexts;
                String it = string;
                boolean bl = false;
                Long l = map.get(it);
                return l != null ? l.longValue() : ((Number)CollectionsKt.first((Iterable)this.$contexts.values())).longValue();
            }
        }), this.verificationTimeout, this.verificationRetryInterval);
        List successfulVerifications = new ArrayList();
        Iterable $this$forEach$iv = testcase.getInstructions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instruction instruction;
            Instruction instruction2 = (Instruction)element$iv;
            boolean bl = false;
            if (contexts.isEmpty()) {
                this.loadContext(contexts);
            }
            if ((instruction = instruction2) instanceof Action) {
                ((Action)instruction2).execute(this.actionExecutor, this.stateProvider, testContext2);
                continue;
            }
            if (!(instruction instanceof Verification)) continue;
            VerificationResult result = this.verifyInstruction((Verification)instruction2, contexts);
            if (result.isFulfilled()) {
                successfulVerifications.add(instruction2);
                continue;
            }
            return new TestResult(testcase, false, result.getFailureMessage(), CollectionsKt.toList((Iterable)successfulVerifications), (Verification)instruction2, this.collectTestOutput());
        }
        return new TestResult(testcase, true, "", CollectionsKt.toList((Iterable)successfulVerifications), null, this.collectTestOutput(), 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadContext(Map<String, Long> contexts) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = this.stateProvider.getProcessInstanceKeys();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void processInstanceKey;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            long l = ((Number)item$iv$iv).longValue();
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(contexts.put("process-" + (int)index, (long)processInstanceKey));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final VerificationResult verifyInstruction(Verification instruction, Map<String, Long> contexts) {
        boolean shouldRetry;
        Instant start = Instant.now();
        VerificationResult result = null;
        do {
            if ((result = instruction.verify(this.stateProvider, contexts)).isFulfilled()) {
                return result;
            }
            shouldRetry = Duration.between(start, Instant.now()).minus(this.verificationTimeout).isNegative();
            if (!shouldRetry) continue;
            Thread.sleep(this.verificationRetryInterval.toMillis());
        } while (shouldRetry);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TestOutput> collectTestOutput() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.stateProvider.getProcessInstanceKeys();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void processInstanceKey;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TestOutput((long)processInstanceKey, this.stateProvider.getProcessInstanceState((long)processInstanceKey), this.stateProvider.getElementInstances((long)processInstanceKey), this.stateProvider.getProcessInstanceVariables((long)processInstanceKey), this.stateProvider.getIncidents((long)processInstanceKey)));
        }
        return (List)destination$iv$iv;
    }

    public SpecRunner() {
        this(null, null, null, null, null, null, 63, null);
    }
}

