/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec.actions;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.zeebe.spec.api.Action;
import org.camunda.community.zeebe.spec.api.TestContext;
import org.camunda.community.zeebe.spec.api.dto.ElementInstance;
import org.camunda.community.zeebe.spec.api.dto.ElementInstanceState;
import org.camunda.community.zeebe.spec.runner.SpecActionExecutor;
import org.camunda.community.zeebe.spec.runner.SpecStateProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/camunda/community/zeebe/spec/actions/AwaitElementInstanceStateAction;", "Lorg/camunda/community/zeebe/spec/api/Action;", "state", "Lorg/camunda/community/zeebe/spec/api/dto/ElementInstanceState;", "elementId", "", "elementName", "processInstance", "(Lorg/camunda/community/zeebe/spec/api/dto/ElementInstanceState;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getElementId", "()Ljava/lang/String;", "getElementName", "getProcessInstance", "getState", "()Lorg/camunda/community/zeebe/spec/api/dto/ElementInstanceState;", "execute", "", "actionExecutor", "Lorg/camunda/community/zeebe/spec/runner/SpecActionExecutor;", "stateProvider", "Lorg/camunda/community/zeebe/spec/runner/SpecStateProvider;", "testContext", "Lorg/camunda/community/zeebe/spec/api/TestContext;", "zeebe-spec-core"})
@SourceDebugExtension(value={"SMAP\nAwaitElementInstanceStateAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwaitElementInstanceStateAction.kt\norg/camunda/community/zeebe/spec/actions/AwaitElementInstanceStateAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n766#2:50\n857#2:51\n858#2:53\n766#2:54\n857#2,2:55\n1#3:52\n*S KotlinDebug\n*F\n+ 1 AwaitElementInstanceStateAction.kt\norg/camunda/community/zeebe/spec/actions/AwaitElementInstanceStateAction\n*L\n30#1:50\n30#1:51\n30#1:53\n33#1:54\n33#1:55,2\n*E\n"})
public final class AwaitElementInstanceStateAction
implements Action {
    @NotNull
    private final ElementInstanceState state;
    @Nullable
    private final String elementId;
    @Nullable
    private final String elementName;
    @Nullable
    private final String processInstance;

    public AwaitElementInstanceStateAction(@NotNull ElementInstanceState state, @Nullable String elementId, @Nullable String elementName, @Nullable String processInstance) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.state = state;
        this.elementId = elementId;
        this.elementName = elementName;
        this.processInstance = processInstance;
    }

    @NotNull
    public final ElementInstanceState getState() {
        return this.state;
    }

    @Nullable
    public final String getElementId() {
        return this.elementId;
    }

    @Nullable
    public final String getElementName() {
        return this.elementName;
    }

    @Nullable
    public final String getProcessInstance() {
        return this.processInstance;
    }

    @Override
    public void execute(@NotNull SpecActionExecutor actionExecutor2, @NotNull SpecStateProvider stateProvider2, @NotNull TestContext testContext2) {
        boolean shouldRetry;
        Intrinsics.checkNotNullParameter((Object)actionExecutor2, (String)"actionExecutor");
        Intrinsics.checkNotNullParameter((Object)stateProvider2, (String)"stateProvider");
        Intrinsics.checkNotNullParameter((Object)testContext2, (String)"testContext");
        long context = ((Number)testContext2.getGetContext().invoke((Object)this.processInstance)).longValue();
        Instant start = Instant.now();
        do {
            boolean bl;
            ElementInstanceState actualState;
            String it;
            ElementInstance elementInstance;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = stateProvider2.getElementInstances(context);
            boolean $i$f$filter = false;
            void var11_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl2;
                elementInstance = (ElementInstance)element$iv$iv;
                boolean bl3 = false;
                if (this.elementId != null) {
                    boolean bl4 = false;
                    bl2 = Intrinsics.areEqual((Object)it, (Object)elementInstance.getElementId());
                } else {
                    bl2 = true;
                }
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl5;
                elementInstance = (ElementInstance)element$iv$iv;
                boolean bl6 = false;
                if (this.elementName != null) {
                    boolean bl7 = false;
                    bl5 = Intrinsics.areEqual((Object)it, (Object)elementInstance.getElementName());
                } else {
                    bl5 = true;
                }
                if (!bl5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            ElementInstance elementInstance2 = (ElementInstance)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            ElementInstanceState elementInstanceState = actualState = elementInstance2 != null ? elementInstance2.getState() : null;
            if (actualState != null) {
                ElementInstanceState it2;
                boolean bl8 = false;
                bl = it2 != this.state;
            } else {
                bl = true;
            }
            boolean bl9 = shouldRetry = bl && Duration.between(start, Instant.now()).minus(testContext2.getVerificationTimeout()).isNegative();
            if (!shouldRetry) continue;
            Thread.sleep(testContext2.getVerificationRetryInterval().toMillis());
        } while (shouldRetry);
    }
}

