/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.zeebe.spec.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.camunda.community.zeebe.spec.actions.CancelInstanceAction;
import org.camunda.community.zeebe.spec.actions.CompleteTaskAction;
import org.camunda.community.zeebe.spec.actions.CreateInstanceAction;
import org.camunda.community.zeebe.spec.actions.PublishMessageAction;
import org.camunda.community.zeebe.spec.actions.ThrowErrorAction;
import org.camunda.community.zeebe.spec.api.Instruction;
import org.camunda.community.zeebe.spec.api.TestCase;
import org.camunda.community.zeebe.spec.api.dto.ElementInstanceState;
import org.camunda.community.zeebe.spec.api.dto.IncidentState;
import org.camunda.community.zeebe.spec.api.dto.ProcessInstanceState;
import org.camunda.community.zeebe.spec.builder.ActionsBuilder;
import org.camunda.community.zeebe.spec.builder.ElementSelector;
import org.camunda.community.zeebe.spec.builder.SpecBuilderKt;
import org.camunda.community.zeebe.spec.builder.TestSpecMarker;
import org.camunda.community.zeebe.spec.builder.VerificationsBuilder;
import org.camunda.community.zeebe.spec.verifications.ElementInstanceStateVerification;
import org.camunda.community.zeebe.spec.verifications.IncidentStateVerification;
import org.camunda.community.zeebe.spec.verifications.NoProcessInstanceVariableVerification;
import org.camunda.community.zeebe.spec.verifications.ProcessInstanceStateVerification;
import org.camunda.community.zeebe.spec.verifications.ProcessInstanceVariableVerification;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TestSpecMarker
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\t\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u00020\n2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0003J$\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00032\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0016J0\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00032\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00162\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0003J,\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0016J \u0010\u001d\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020\u0003J\u001f\u0010 \u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0002\b\u000eJ\"\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0003J8\u0010'\u001a\u00020\n2\u0006\u0010%\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0003J&\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00032\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\u001a\u0010,\u001a\u00020\n2\u0006\u0010%\u001a\u00020-2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0003J.\u0010.\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00012\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0003J2\u00100\u001a\u00020\n2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00162\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/camunda/community/zeebe/spec/builder/TestCaseBuilder;", "", "name", "", "description", "(Ljava/lang/String;Ljava/lang/String;)V", "instructions", "", "Lorg/camunda/community/zeebe/spec/api/Instruction;", "actions", "", "init", "Lkotlin/Function1;", "Lorg/camunda/community/zeebe/spec/builder/ActionsBuilder;", "Lkotlin/ExtensionFunctionType;", "build", "Lorg/camunda/community/zeebe/spec/api/TestCase;", "cancelInstance", "processInstance", "completeTask", "jobType", "variables", "", "createInstance", "bpmnProcessId", "processInstanceAlias", "publishMessage", "messageName", "correlationKey", "throwError", "errorCode", "errorMessage", "verifications", "Lorg/camunda/community/zeebe/spec/builder/VerificationsBuilder;", "verifyElementInstanceState", "selector", "Lorg/camunda/community/zeebe/spec/builder/ElementSelector;", "state", "Lorg/camunda/community/zeebe/spec/api/dto/ElementInstanceState;", "verifyIncidentState", "Lorg/camunda/community/zeebe/spec/api/dto/IncidentState;", "errorType", "verifyNoProcessInstanceVariable", "variableName", "verifyProcessInstanceState", "Lorg/camunda/community/zeebe/spec/api/dto/ProcessInstanceState;", "verifyProcessInstanceVariable", "value", "verifyProcessInstanceVariables", "zeebe-spec-core"})
@SourceDebugExtension(value={"SMAP\nSpecBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecBuilder.kt\norg/camunda/community/zeebe/spec/builder/TestCaseBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,356:1\n215#2,2:357\n*S KotlinDebug\n*F\n+ 1 SpecBuilder.kt\norg/camunda/community/zeebe/spec/builder/TestCaseBuilder\n*L\n150#1:357,2\n*E\n"})
public final class TestCaseBuilder {
    @NotNull
    private final String name;
    @Nullable
    private final String description;
    @NotNull
    private final List<Instruction> instructions;

    public TestCaseBuilder(@NotNull String name, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.description = description;
        this.instructions = new ArrayList();
    }

    public final void actions(@NotNull Function1<? super ActionsBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        ActionsBuilder actionsBuilder = new ActionsBuilder();
        init.invoke((Object)actionsBuilder);
        this.instructions.addAll((Collection<Instruction>)actionsBuilder.build());
    }

    public final void verifications(@NotNull Function1<? super VerificationsBuilder, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        VerificationsBuilder verificationsBuilder = new VerificationsBuilder();
        init.invoke((Object)verificationsBuilder);
        this.instructions.addAll((Collection<Instruction>)verificationsBuilder.build());
    }

    public final void completeTask(@NotNull String jobType, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)jobType, (String)"jobType");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        this.instructions.add(new CompleteTaskAction(jobType, SpecBuilderKt.access$serializeToJSON(variables)));
    }

    public static /* synthetic */ void completeTask$default(TestCaseBuilder testCaseBuilder, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        testCaseBuilder.completeTask(string, map);
    }

    public final void cancelInstance(@Nullable String processInstance) {
        this.instructions.add(new CancelInstanceAction(processInstance));
    }

    public static /* synthetic */ void cancelInstance$default(TestCaseBuilder testCaseBuilder, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        testCaseBuilder.cancelInstance(string);
    }

    public final void createInstance(@NotNull String bpmnProcessId, @NotNull Map<String, ? extends Object> variables, @Nullable String processInstanceAlias) {
        Intrinsics.checkNotNullParameter((Object)bpmnProcessId, (String)"bpmnProcessId");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        this.instructions.add(new CreateInstanceAction(bpmnProcessId, SpecBuilderKt.access$serializeToJSON(variables), processInstanceAlias));
    }

    public static /* synthetic */ void createInstance$default(TestCaseBuilder testCaseBuilder, String string, Map map, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        testCaseBuilder.createInstance(string, map, string2);
    }

    public final void publishMessage(@NotNull String messageName, @NotNull String correlationKey, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)messageName, (String)"messageName");
        Intrinsics.checkNotNullParameter((Object)correlationKey, (String)"correlationKey");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        this.instructions.add(new PublishMessageAction(messageName, correlationKey, SpecBuilderKt.access$serializeToJSON(variables)));
    }

    public static /* synthetic */ void publishMessage$default(TestCaseBuilder testCaseBuilder, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        testCaseBuilder.publishMessage(string, string2, map);
    }

    public final void throwError(@NotNull String jobType, @NotNull String errorCode, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)jobType, (String)"jobType");
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.instructions.add(new ThrowErrorAction(jobType, errorCode, errorMessage));
    }

    public static /* synthetic */ void throwError$default(TestCaseBuilder testCaseBuilder, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        testCaseBuilder.throwError(string, string2, string3);
    }

    public final void verifyProcessInstanceState(@NotNull ProcessInstanceState state, @Nullable String processInstanceAlias) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.instructions.add(new ProcessInstanceStateVerification(state, processInstanceAlias));
    }

    public static /* synthetic */ void verifyProcessInstanceState$default(TestCaseBuilder testCaseBuilder, ProcessInstanceState processInstanceState, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        testCaseBuilder.verifyProcessInstanceState(processInstanceState, string);
    }

    public final void verifyElementInstanceState(@NotNull ElementSelector selector, @NotNull ElementInstanceState state, @Nullable String processInstanceAlias) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.instructions.add(new ElementInstanceStateVerification(state, selector.getElementId(), selector.getElementName(), processInstanceAlias));
    }

    public static /* synthetic */ void verifyElementInstanceState$default(TestCaseBuilder testCaseBuilder, ElementSelector elementSelector, ElementInstanceState elementInstanceState, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        testCaseBuilder.verifyElementInstanceState(elementSelector, elementInstanceState, string);
    }

    public final void verifyProcessInstanceVariable(@NotNull String variableName, @NotNull Object value, @Nullable ElementSelector selector, @Nullable String processInstanceAlias) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ElementSelector elementSelector = selector;
        ElementSelector elementSelector2 = selector;
        this.instructions.add(new ProcessInstanceVariableVerification(variableName, SpecBuilderKt.access$serializeToJSON(value), processInstanceAlias, elementSelector != null ? elementSelector.getElementId() : null, elementSelector2 != null ? elementSelector2.getElementName() : null));
    }

    public static /* synthetic */ void verifyProcessInstanceVariable$default(TestCaseBuilder testCaseBuilder, String string, Object object, ElementSelector elementSelector, String string2, int n, Object object2) {
        if ((n & 4) != 0) {
            elementSelector = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        testCaseBuilder.verifyProcessInstanceVariable(string, object, elementSelector, string2);
    }

    public final void verifyProcessInstanceVariables(@NotNull Map<String, ? extends Object> variables, @Nullable ElementSelector selector, @Nullable String processInstanceAlias) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Map<String, ? extends Object> $this$forEach$iv = variables;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            this.verifyProcessInstanceVariable(key, value, selector, processInstanceAlias);
        }
    }

    public static /* synthetic */ void verifyProcessInstanceVariables$default(TestCaseBuilder testCaseBuilder, Map map, ElementSelector elementSelector, String string, int n, Object object) {
        if ((n & 2) != 0) {
            elementSelector = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        testCaseBuilder.verifyProcessInstanceVariables(map, elementSelector, string);
    }

    public final void verifyNoProcessInstanceVariable(@NotNull String variableName, @Nullable ElementSelector selector, @Nullable String processInstanceAlias) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        ElementSelector elementSelector = selector;
        ElementSelector elementSelector2 = selector;
        this.instructions.add(new NoProcessInstanceVariableVerification(variableName, processInstanceAlias, elementSelector != null ? elementSelector.getElementId() : null, elementSelector2 != null ? elementSelector2.getElementName() : null));
    }

    public static /* synthetic */ void verifyNoProcessInstanceVariable$default(TestCaseBuilder testCaseBuilder, String string, ElementSelector elementSelector, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            elementSelector = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        testCaseBuilder.verifyNoProcessInstanceVariable(string, elementSelector, string2);
    }

    public final void verifyIncidentState(@NotNull IncidentState state, @NotNull String errorType, @Nullable String errorMessage, @Nullable ElementSelector selector, @Nullable String processInstanceAlias) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)errorType, (String)"errorType");
        ElementSelector elementSelector = selector;
        ElementSelector elementSelector2 = selector;
        this.instructions.add(new IncidentStateVerification(state, errorType, errorMessage, elementSelector != null ? elementSelector.getElementId() : null, elementSelector2 != null ? elementSelector2.getElementName() : null, processInstanceAlias));
    }

    public static /* synthetic */ void verifyIncidentState$default(TestCaseBuilder testCaseBuilder, IncidentState incidentState, String string, String string2, ElementSelector elementSelector, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            elementSelector = null;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        testCaseBuilder.verifyIncidentState(incidentState, string, string2, elementSelector, string3);
    }

    @NotNull
    public final TestCase build() {
        return new TestCase(this.name, this.description, this.instructions);
    }
}

